package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{Timestamp, LifecycleEventName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LifecycleEvent(
    lifecycleEventName: Optional[LifecycleEventName] = Optional.Absent,
    diagnostics: Optional[zio.aws.codedeploy.model.Diagnostics] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.codedeploy.model.LifecycleEventStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.LifecycleEvent = {
    import LifecycleEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.LifecycleEvent
      .builder()
      .optionallyWith(
        lifecycleEventName.map(value =>
          LifecycleEventName.unwrap(value): java.lang.String
        )
      )(_.lifecycleEventName)
      .optionallyWith(diagnostics.map(value => value.buildAwsValue()))(
        _.diagnostics
      )
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.LifecycleEvent.ReadOnly =
    zio.aws.codedeploy.model.LifecycleEvent.wrap(buildAwsValue())
}
object LifecycleEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.LifecycleEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.LifecycleEvent =
      zio.aws.codedeploy.model.LifecycleEvent(
        lifecycleEventName.map(value => value),
        diagnostics.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        status.map(value => value)
      )
    def lifecycleEventName: Optional[LifecycleEventName]
    def diagnostics: Optional[zio.aws.codedeploy.model.Diagnostics.ReadOnly]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def status: Optional[zio.aws.codedeploy.model.LifecycleEventStatus]
    def getLifecycleEventName: ZIO[Any, AwsError, LifecycleEventName] =
      AwsError.unwrapOptionField("lifecycleEventName", lifecycleEventName)
    def getDiagnostics
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.Diagnostics.ReadOnly] =
      AwsError.unwrapOptionField("diagnostics", diagnostics)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.LifecycleEventStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.LifecycleEvent
  ) extends zio.aws.codedeploy.model.LifecycleEvent.ReadOnly {
    override val lifecycleEventName: Optional[LifecycleEventName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleEventName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.LifecycleEventName(value)
        )
    override val diagnostics
        : Optional[zio.aws.codedeploy.model.Diagnostics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diagnostics())
        .map(value => zio.aws.codedeploy.model.Diagnostics.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.codedeploy.model.LifecycleEventStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codedeploy.model.LifecycleEventStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.LifecycleEvent
  ): zio.aws.codedeploy.model.LifecycleEvent.ReadOnly = new Wrapper(impl)
}
