package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{TargetId, DeploymentId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDeploymentTargetRequest(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    targetId: Optional[TargetId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest = {
    import GetDeploymentTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetDeploymentTargetRequest.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentTargetRequest.wrap(buildAwsValue())
}
object GetDeploymentTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentTargetRequest =
      zio.aws.codedeploy.model.GetDeploymentTargetRequest(
        deploymentId.map(value => value),
        targetId.map(value => value)
      )
    def deploymentId: Optional[DeploymentId]
    def targetId: Optional[TargetId]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest
  ) extends zio.aws.codedeploy.model.GetDeploymentTargetRequest.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val targetId: Optional[TargetId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetId())
      .map(value => zio.aws.codedeploy.model.primitives.TargetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentTargetRequest
  ): zio.aws.codedeploy.model.GetDeploymentTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
