package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait BundleType {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.BundleType
}
object BundleType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.BundleType
  ): zio.aws.codedeploy.model.BundleType = value match {
    case software.amazon.awssdk.services.codedeploy.model.BundleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.BundleType.TAR =>
      val r = tar
      r
    case software.amazon.awssdk.services.codedeploy.model.BundleType.TGZ =>
      val r = tgz
      r
    case software.amazon.awssdk.services.codedeploy.model.BundleType.ZIP =>
      val r = zip
      r
    case software.amazon.awssdk.services.codedeploy.model.BundleType.YAML =>
      val r = YAML
      r
    case software.amazon.awssdk.services.codedeploy.model.BundleType.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion extends zio.aws.codedeploy.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.BundleType =
      software.amazon.awssdk.services.codedeploy.model.BundleType.UNKNOWN_TO_SDK_VERSION
  }
  case object tar extends zio.aws.codedeploy.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.BundleType =
      software.amazon.awssdk.services.codedeploy.model.BundleType.TAR
  }
  case object tgz extends zio.aws.codedeploy.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.BundleType =
      software.amazon.awssdk.services.codedeploy.model.BundleType.TGZ
  }
  case object zip extends zio.aws.codedeploy.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.BundleType =
      software.amazon.awssdk.services.codedeploy.model.BundleType.ZIP
  }
  case object YAML extends zio.aws.codedeploy.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.BundleType =
      software.amazon.awssdk.services.codedeploy.model.BundleType.YAML
  }
  case object JSON extends zio.aws.codedeploy.model.BundleType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.BundleType =
      software.amazon.awssdk.services.codedeploy.model.BundleType.JSON
  }
}
