package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  AutoScalingGroupHook,
  AutoScalingGroupName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutoScalingGroup(
    name: Optional[AutoScalingGroupName] = Optional.Absent,
    hook: Optional[AutoScalingGroupHook] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.AutoScalingGroup = {
    import AutoScalingGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.AutoScalingGroup
      .builder()
      .optionallyWith(
        name.map(value => AutoScalingGroupName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        hook.map(value => AutoScalingGroupHook.unwrap(value): java.lang.String)
      )(_.hook)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly =
    zio.aws.codedeploy.model.AutoScalingGroup.wrap(buildAwsValue())
}
object AutoScalingGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.AutoScalingGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.AutoScalingGroup =
      zio.aws.codedeploy.model
        .AutoScalingGroup(name.map(value => value), hook.map(value => value))
    def name: Optional[AutoScalingGroupName]
    def hook: Optional[AutoScalingGroupHook]
    def getName: ZIO[Any, AwsError, AutoScalingGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getHook: ZIO[Any, AwsError, AutoScalingGroupHook] =
      AwsError.unwrapOptionField("hook", hook)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.AutoScalingGroup
  ) extends zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly {
    override val name: Optional[AutoScalingGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.codedeploy.model.primitives.AutoScalingGroupName(value)
      )
    override val hook: Optional[AutoScalingGroupHook] = zio.aws.core.internal
      .optionalFromNullable(impl.hook())
      .map(value =>
        zio.aws.codedeploy.model.primitives.AutoScalingGroupHook(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.AutoScalingGroup
  ): zio.aws.codedeploy.model.AutoScalingGroup.ReadOnly = new Wrapper(impl)
}
