package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.{
  DeploymentGroupName,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class GetDeploymentGroupRequest(
    applicationName: ApplicationName,
    deploymentGroupName: DeploymentGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest = {
    import GetDeploymentGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .deploymentGroupName(
        DeploymentGroupName.unwrap(deploymentGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetDeploymentGroupRequest.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentGroupRequest.wrap(buildAwsValue())
}
object GetDeploymentGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentGroupRequest =
      zio.aws.codedeploy.model
        .GetDeploymentGroupRequest(applicationName, deploymentGroupName)
    def applicationName: ApplicationName
    def deploymentGroupName: DeploymentGroupName
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getDeploymentGroupName: ZIO[Any, Nothing, DeploymentGroupName] =
      ZIO.succeed(deploymentGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest
  ) extends zio.aws.codedeploy.model.GetDeploymentGroupRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val deploymentGroupName: DeploymentGroupName =
      zio.aws.codedeploy.model.primitives
        .DeploymentGroupName(impl.deploymentGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupRequest
  ): zio.aws.codedeploy.model.GetDeploymentGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
