package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{CommitId, Repository}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GitHubLocation(
    repository: Optional[Repository] = Optional.Absent,
    commitId: Optional[CommitId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GitHubLocation = {
    import GitHubLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GitHubLocation
      .builder()
      .optionallyWith(
        repository.map(value => Repository.unwrap(value): java.lang.String)
      )(_.repository)
      .optionallyWith(
        commitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.commitId)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GitHubLocation.ReadOnly =
    zio.aws.codedeploy.model.GitHubLocation.wrap(buildAwsValue())
}
object GitHubLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GitHubLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GitHubLocation =
      zio.aws.codedeploy.model.GitHubLocation(
        repository.map(value => value),
        commitId.map(value => value)
      )
    def repository: Optional[Repository]
    def commitId: Optional[CommitId]
    def getRepository: ZIO[Any, AwsError, Repository] =
      AwsError.unwrapOptionField("repository", repository)
    def getCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("commitId", commitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GitHubLocation
  ) extends zio.aws.codedeploy.model.GitHubLocation.ReadOnly {
    override val repository: Optional[Repository] = zio.aws.core.internal
      .optionalFromNullable(impl.repository())
      .map(value => zio.aws.codedeploy.model.primitives.Repository(value))
    override val commitId: Optional[CommitId] = zio.aws.core.internal
      .optionalFromNullable(impl.commitId())
      .map(value => zio.aws.codedeploy.model.primitives.CommitId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GitHubLocation
  ): zio.aws.codedeploy.model.GitHubLocation.ReadOnly = new Wrapper(impl)
}
