package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.ApplicationName
import scala.jdk.CollectionConverters._
final case class GetApplicationRevisionRequest(
    applicationName: ApplicationName,
    revision: zio.aws.codedeploy.model.RevisionLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest = {
    import GetApplicationRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .revision(revision.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.GetApplicationRevisionRequest.ReadOnly =
    zio.aws.codedeploy.model.GetApplicationRevisionRequest.wrap(buildAwsValue())
}
object GetApplicationRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetApplicationRevisionRequest =
      zio.aws.codedeploy.model
        .GetApplicationRevisionRequest(applicationName, revision.asEditable)
    def applicationName: ApplicationName
    def revision: zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getRevision: ZIO[
      Any,
      Nothing,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest
  ) extends zio.aws.codedeploy.model.GetApplicationRevisionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val revision: zio.aws.codedeploy.model.RevisionLocation.ReadOnly =
      zio.aws.codedeploy.model.RevisionLocation.wrap(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetApplicationRevisionRequest
  ): zio.aws.codedeploy.model.GetApplicationRevisionRequest.ReadOnly =
    new Wrapper(impl)
}
