package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait LifecycleEventStatus {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus
}
object LifecycleEventStatus {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus
  ): zio.aws.codedeploy.model.LifecycleEventStatus = value match {
    case software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.SKIPPED =>
      val r = Skipped
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.UNKNOWN =>
      val r = Unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.LifecycleEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus =
      software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.codedeploy.model.LifecycleEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus =
      software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.PENDING
  }
  case object InProgress extends zio.aws.codedeploy.model.LifecycleEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus =
      software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.IN_PROGRESS
  }
  case object Succeeded extends zio.aws.codedeploy.model.LifecycleEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus =
      software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.SUCCEEDED
  }
  case object Failed extends zio.aws.codedeploy.model.LifecycleEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus =
      software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.FAILED
  }
  case object Skipped extends zio.aws.codedeploy.model.LifecycleEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus =
      software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.SKIPPED
  }
  case object Unknown extends zio.aws.codedeploy.model.LifecycleEventStatus {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus =
      software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus.UNKNOWN
  }
}
