package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetApplicationsResponse(
    applicationsInfo: Optional[
      Iterable[zio.aws.codedeploy.model.ApplicationInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse = {
    import BatchGetApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse
      .builder()
      .optionallyWith(
        applicationsInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationsInfo)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.BatchGetApplicationsResponse.ReadOnly =
    zio.aws.codedeploy.model.BatchGetApplicationsResponse.wrap(buildAwsValue())
}
object BatchGetApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.BatchGetApplicationsResponse =
      zio.aws.codedeploy.model.BatchGetApplicationsResponse(
        applicationsInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def applicationsInfo
        : Optional[List[zio.aws.codedeploy.model.ApplicationInfo.ReadOnly]]
    def getApplicationsInfo: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.ApplicationInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("applicationsInfo", applicationsInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse
  ) extends zio.aws.codedeploy.model.BatchGetApplicationsResponse.ReadOnly {
    override val applicationsInfo
        : Optional[List[zio.aws.codedeploy.model.ApplicationInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationsInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.ApplicationInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.BatchGetApplicationsResponse
  ): zio.aws.codedeploy.model.BatchGetApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
