package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDeploymentGroupResponse(
    deploymentGroupInfo: Optional[
      zio.aws.codedeploy.model.DeploymentGroupInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse = {
    import GetDeploymentGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse
      .builder()
      .optionallyWith(deploymentGroupInfo.map(value => value.buildAwsValue()))(
        _.deploymentGroupInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetDeploymentGroupResponse.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentGroupResponse.wrap(buildAwsValue())
}
object GetDeploymentGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentGroupResponse =
      zio.aws.codedeploy.model.GetDeploymentGroupResponse(
        deploymentGroupInfo.map(value => value.asEditable)
      )
    def deploymentGroupInfo
        : Optional[zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly]
    def getDeploymentGroupInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentGroupInfo", deploymentGroupInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse
  ) extends zio.aws.codedeploy.model.GetDeploymentGroupResponse.ReadOnly {
    override val deploymentGroupInfo
        : Optional[zio.aws.codedeploy.model.DeploymentGroupInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentGroupInfo())
        .map(value => zio.aws.codedeploy.model.DeploymentGroupInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentGroupResponse
  ): zio.aws.codedeploy.model.GetDeploymentGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
