package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{Timestamp, DeploymentId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LastDeploymentInfo(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    status: Optional[zio.aws.codedeploy.model.DeploymentStatus] =
      Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    createTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo = {
    import LastDeploymentInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        createTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTime)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly =
    zio.aws.codedeploy.model.LastDeploymentInfo.wrap(buildAwsValue())
}
object LastDeploymentInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.LastDeploymentInfo =
      zio.aws.codedeploy.model.LastDeploymentInfo(
        deploymentId.map(value => value),
        status.map(value => value),
        endTime.map(value => value),
        createTime.map(value => value)
      )
    def deploymentId: Optional[DeploymentId]
    def status: Optional[zio.aws.codedeploy.model.DeploymentStatus]
    def endTime: Optional[Timestamp]
    def createTime: Optional[Timestamp]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCreateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo
  ) extends zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val status: Optional[zio.aws.codedeploy.model.DeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codedeploy.model.DeploymentStatus.wrap(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val createTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo
  ): zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly = new Wrapper(impl)
}
