package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{
  InstanceArn,
  IamUserArn,
  IamSessionArn,
  Timestamp,
  InstanceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class InstanceInfo(
    instanceName: Optional[InstanceName] = Optional.Absent,
    iamSessionArn: Optional[IamSessionArn] = Optional.Absent,
    iamUserArn: Optional[IamUserArn] = Optional.Absent,
    instanceArn: Optional[InstanceArn] = Optional.Absent,
    registerTime: Optional[Timestamp] = Optional.Absent,
    deregisterTime: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.codedeploy.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.InstanceInfo = {
    import InstanceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.InstanceInfo
      .builder()
      .optionallyWith(
        instanceName.map(value => InstanceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(
        iamSessionArn.map(value =>
          IamSessionArn.unwrap(value): java.lang.String
        )
      )(_.iamSessionArn)
      .optionallyWith(
        iamUserArn.map(value => IamUserArn.unwrap(value): java.lang.String)
      )(_.iamUserArn)
      .optionallyWith(
        instanceArn.map(value => InstanceArn.unwrap(value): java.lang.String)
      )(_.instanceArn)
      .optionallyWith(
        registerTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.registerTime)
      .optionallyWith(
        deregisterTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.deregisterTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.InstanceInfo.ReadOnly =
    zio.aws.codedeploy.model.InstanceInfo.wrap(buildAwsValue())
}
object InstanceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.InstanceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.InstanceInfo =
      zio.aws.codedeploy.model.InstanceInfo(
        instanceName.map(value => value),
        iamSessionArn.map(value => value),
        iamUserArn.map(value => value),
        instanceArn.map(value => value),
        registerTime.map(value => value),
        deregisterTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceName: Optional[InstanceName]
    def iamSessionArn: Optional[IamSessionArn]
    def iamUserArn: Optional[IamUserArn]
    def instanceArn: Optional[InstanceArn]
    def registerTime: Optional[Timestamp]
    def deregisterTime: Optional[Timestamp]
    def tags: Optional[List[zio.aws.codedeploy.model.Tag.ReadOnly]]
    def getInstanceName: ZIO[Any, AwsError, InstanceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getIamSessionArn: ZIO[Any, AwsError, IamSessionArn] =
      AwsError.unwrapOptionField("iamSessionArn", iamSessionArn)
    def getIamUserArn: ZIO[Any, AwsError, IamUserArn] =
      AwsError.unwrapOptionField("iamUserArn", iamUserArn)
    def getInstanceArn: ZIO[Any, AwsError, InstanceArn] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getRegisterTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registerTime", registerTime)
    def getDeregisterTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deregisterTime", deregisterTime)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.InstanceInfo
  ) extends zio.aws.codedeploy.model.InstanceInfo.ReadOnly {
    override val instanceName: Optional[InstanceName] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceName())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceName(value))
    override val iamSessionArn: Optional[IamSessionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamSessionArn())
      .map(value => zio.aws.codedeploy.model.primitives.IamSessionArn(value))
    override val iamUserArn: Optional[IamUserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamUserArn())
      .map(value => zio.aws.codedeploy.model.primitives.IamUserArn(value))
    override val instanceArn: Optional[InstanceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceArn())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceArn(value))
    override val registerTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.registerTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val deregisterTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deregisterTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val tags: Optional[List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.InstanceInfo
  ): zio.aws.codedeploy.model.InstanceInfo.ReadOnly = new Wrapper(impl)
}
