package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait TargetFilterName {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.TargetFilterName
}
object TargetFilterName {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.TargetFilterName
  ): zio.aws.codedeploy.model.TargetFilterName = value match {
    case software.amazon.awssdk.services.codedeploy.model.TargetFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetFilterName.TARGET_STATUS =>
      val r = TargetStatus
      r
    case software.amazon.awssdk.services.codedeploy.model.TargetFilterName.SERVER_INSTANCE_LABEL =>
      val r = ServerInstanceLabel
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.TargetFilterName {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetFilterName =
      software.amazon.awssdk.services.codedeploy.model.TargetFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object TargetStatus extends zio.aws.codedeploy.model.TargetFilterName {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetFilterName =
      software.amazon.awssdk.services.codedeploy.model.TargetFilterName.TARGET_STATUS
  }
  case object ServerInstanceLabel
      extends zio.aws.codedeploy.model.TargetFilterName {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TargetFilterName =
      software.amazon.awssdk.services.codedeploy.model.TargetFilterName.SERVER_INSTANCE_LABEL
  }
}
