package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOnPremisesInstancesRequest(
    registrationStatus: Optional[zio.aws.codedeploy.model.RegistrationStatus] =
      Optional.Absent,
    tagFilters: Optional[Iterable[zio.aws.codedeploy.model.TagFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest = {
    import ListOnPremisesInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest
      .builder()
      .optionallyWith(registrationStatus.map(value => value.unwrap))(
        _.registrationStatus
      )
      .optionallyWith(
        tagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagFilters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListOnPremisesInstancesRequest.ReadOnly =
    zio.aws.codedeploy.model.ListOnPremisesInstancesRequest
      .wrap(buildAwsValue())
}
object ListOnPremisesInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListOnPremisesInstancesRequest =
      zio.aws.codedeploy.model.ListOnPremisesInstancesRequest(
        registrationStatus.map(value => value),
        tagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def registrationStatus
        : Optional[zio.aws.codedeploy.model.RegistrationStatus]
    def tagFilters: Optional[List[zio.aws.codedeploy.model.TagFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getRegistrationStatus
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.RegistrationStatus] =
      AwsError.unwrapOptionField("registrationStatus", registrationStatus)
    def getTagFilters: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("tagFilters", tagFilters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest
  ) extends zio.aws.codedeploy.model.ListOnPremisesInstancesRequest.ReadOnly {
    override val registrationStatus
        : Optional[zio.aws.codedeploy.model.RegistrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationStatus())
        .map(value => zio.aws.codedeploy.model.RegistrationStatus.wrap(value))
    override val tagFilters
        : Optional[List[zio.aws.codedeploy.model.TagFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.TagFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListOnPremisesInstancesRequest
  ): zio.aws.codedeploy.model.ListOnPremisesInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
