package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  NextToken,
  S3Key,
  S3Bucket,
  ApplicationName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationRevisionsRequest(
    applicationName: ApplicationName,
    sortBy: Optional[zio.aws.codedeploy.model.ApplicationRevisionSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.codedeploy.model.SortOrder] = Optional.Absent,
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3KeyPrefix: Optional[S3Key] = Optional.Absent,
    deployed: Optional[zio.aws.codedeploy.model.ListStateFilterAction] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest = {
    import ListApplicationRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3KeyPrefix.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .optionallyWith(deployed.map(value => value.unwrap))(_.deployed)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListApplicationRevisionsRequest.ReadOnly =
    zio.aws.codedeploy.model.ListApplicationRevisionsRequest
      .wrap(buildAwsValue())
}
object ListApplicationRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListApplicationRevisionsRequest =
      zio.aws.codedeploy.model.ListApplicationRevisionsRequest(
        applicationName,
        sortBy.map(value => value),
        sortOrder.map(value => value),
        s3Bucket.map(value => value),
        s3KeyPrefix.map(value => value),
        deployed.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: ApplicationName
    def sortBy: Optional[zio.aws.codedeploy.model.ApplicationRevisionSortBy]
    def sortOrder: Optional[zio.aws.codedeploy.model.SortOrder]
    def s3Bucket: Optional[S3Bucket]
    def s3KeyPrefix: Optional[S3Key]
    def deployed: Optional[zio.aws.codedeploy.model.ListStateFilterAction]
    def nextToken: Optional[NextToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.ApplicationRevisionSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.codedeploy.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3KeyPrefix: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getDeployed
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ListStateFilterAction] =
      AwsError.unwrapOptionField("deployed", deployed)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest
  ) extends zio.aws.codedeploy.model.ListApplicationRevisionsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val sortBy
        : Optional[zio.aws.codedeploy.model.ApplicationRevisionSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.codedeploy.model.ApplicationRevisionSortBy.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.codedeploy.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.codedeploy.model.SortOrder.wrap(value))
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.codedeploy.model.primitives.S3Bucket(value))
    override val s3KeyPrefix: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => zio.aws.codedeploy.model.primitives.S3Key(value))
    override val deployed
        : Optional[zio.aws.codedeploy.model.ListStateFilterAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deployed())
        .map(value =>
          zio.aws.codedeploy.model.ListStateFilterAction.wrap(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest
  ): zio.aws.codedeploy.model.ListApplicationRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
