package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  FilterValue,
  NextToken,
  DeploymentId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDeploymentTargetsRequest(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    targetFilters: Optional[
      Map[zio.aws.codedeploy.model.TargetFilterName, Iterable[FilterValue]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest = {
    import ListDeploymentTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        targetFilters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                FilterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.targetFiltersWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentTargetsRequest.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentTargetsRequest.wrap(buildAwsValue())
}
object ListDeploymentTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentTargetsRequest =
      zio.aws.codedeploy.model.ListDeploymentTargetsRequest(
        deploymentId.map(value => value),
        nextToken.map(value => value),
        targetFilters.map(value => value)
      )
    def deploymentId: Optional[DeploymentId]
    def nextToken: Optional[NextToken]
    def targetFilters: Optional[
      Map[zio.aws.codedeploy.model.TargetFilterName, List[FilterValue]]
    ]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTargetFilters: ZIO[Any, AwsError, Map[
      zio.aws.codedeploy.model.TargetFilterName,
      List[FilterValue]
    ]] = AwsError.unwrapOptionField("targetFilters", targetFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest
  ) extends zio.aws.codedeploy.model.ListDeploymentTargetsRequest.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
    override val targetFilters: Optional[
      Map[zio.aws.codedeploy.model.TargetFilterName, List[FilterValue]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetFilters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codedeploy.model.TargetFilterName
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.codedeploy.model.primitives.FilterValue(item)
            }.toList
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentTargetsRequest
  ): zio.aws.codedeploy.model.ListDeploymentTargetsRequest.ReadOnly =
    new Wrapper(impl)
}
