package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.InstanceCount
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeploymentOverview(
    pending: Optional[InstanceCount] = Optional.Absent,
    inProgress: Optional[InstanceCount] = Optional.Absent,
    succeeded: Optional[InstanceCount] = Optional.Absent,
    failed: Optional[InstanceCount] = Optional.Absent,
    skipped: Optional[InstanceCount] = Optional.Absent,
    ready: Optional[InstanceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeploymentOverview = {
    import DeploymentOverview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeploymentOverview
      .builder()
      .optionallyWith(
        pending.map(value => InstanceCount.unwrap(value): java.lang.Long)
      )(_.pending)
      .optionallyWith(
        inProgress.map(value => InstanceCount.unwrap(value): java.lang.Long)
      )(_.inProgress)
      .optionallyWith(
        succeeded.map(value => InstanceCount.unwrap(value): java.lang.Long)
      )(_.succeeded)
      .optionallyWith(
        failed.map(value => InstanceCount.unwrap(value): java.lang.Long)
      )(_.failed)
      .optionallyWith(
        skipped.map(value => InstanceCount.unwrap(value): java.lang.Long)
      )(_.skipped)
      .optionallyWith(
        ready.map(value => InstanceCount.unwrap(value): java.lang.Long)
      )(_.ready)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeploymentOverview.ReadOnly =
    zio.aws.codedeploy.model.DeploymentOverview.wrap(buildAwsValue())
}
object DeploymentOverview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeploymentOverview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeploymentOverview =
      zio.aws.codedeploy.model.DeploymentOverview(
        pending.map(value => value),
        inProgress.map(value => value),
        succeeded.map(value => value),
        failed.map(value => value),
        skipped.map(value => value),
        ready.map(value => value)
      )
    def pending: Optional[InstanceCount]
    def inProgress: Optional[InstanceCount]
    def succeeded: Optional[InstanceCount]
    def failed: Optional[InstanceCount]
    def skipped: Optional[InstanceCount]
    def ready: Optional[InstanceCount]
    def getPending: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("pending", pending)
    def getInProgress: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("inProgress", inProgress)
    def getSucceeded: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("succeeded", succeeded)
    def getFailed: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("failed", failed)
    def getSkipped: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("skipped", skipped)
    def getReady: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("ready", ready)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentOverview
  ) extends zio.aws.codedeploy.model.DeploymentOverview.ReadOnly {
    override val pending: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.pending())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceCount(value))
    override val inProgress: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.inProgress())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceCount(value))
    override val succeeded: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.succeeded())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceCount(value))
    override val failed: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.failed())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceCount(value))
    override val skipped: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.skipped())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceCount(value))
    override val ready: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.ready())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentOverview
  ): zio.aws.codedeploy.model.DeploymentOverview.ReadOnly = new Wrapper(impl)
}
