package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentWaitType {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType
}
object DeploymentWaitType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType
  ): zio.aws.codedeploy.model.DeploymentWaitType = value match {
    case software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType.READY_WAIT =>
      val r = READY_WAIT
      r
    case software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType.TERMINATION_WAIT =>
      val r = TERMINATION_WAIT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.DeploymentWaitType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType.UNKNOWN_TO_SDK_VERSION
  }
  case object READY_WAIT extends zio.aws.codedeploy.model.DeploymentWaitType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType.READY_WAIT
  }
  case object TERMINATION_WAIT
      extends zio.aws.codedeploy.model.DeploymentWaitType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType =
      software.amazon.awssdk.services.codedeploy.model.DeploymentWaitType.TERMINATION_WAIT
  }
}
