package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RevisionLocation(
    revisionType: Optional[zio.aws.codedeploy.model.RevisionLocationType] =
      Optional.Absent,
    s3Location: Optional[zio.aws.codedeploy.model.S3Location] = Optional.Absent,
    gitHubLocation: Optional[zio.aws.codedeploy.model.GitHubLocation] =
      Optional.Absent,
    string: Optional[zio.aws.codedeploy.model.RawString] = Optional.Absent,
    appSpecContent: Optional[zio.aws.codedeploy.model.AppSpecContent] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RevisionLocation = {
    import RevisionLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RevisionLocation
      .builder()
      .optionallyWith(revisionType.map(value => value.unwrap))(_.revisionType)
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .optionallyWith(gitHubLocation.map(value => value.buildAwsValue()))(
        _.gitHubLocation
      )
      .optionallyWith(string.map(value => value.buildAwsValue()))(_.string)
      .optionallyWith(appSpecContent.map(value => value.buildAwsValue()))(
        _.appSpecContent
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.RevisionLocation.ReadOnly =
    zio.aws.codedeploy.model.RevisionLocation.wrap(buildAwsValue())
}
object RevisionLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RevisionLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.RevisionLocation =
      zio.aws.codedeploy.model.RevisionLocation(
        revisionType.map(value => value),
        s3Location.map(value => value.asEditable),
        gitHubLocation.map(value => value.asEditable),
        string.map(value => value.asEditable),
        appSpecContent.map(value => value.asEditable)
      )
    def revisionType: Optional[zio.aws.codedeploy.model.RevisionLocationType]
    def s3Location: Optional[zio.aws.codedeploy.model.S3Location.ReadOnly]
    def gitHubLocation
        : Optional[zio.aws.codedeploy.model.GitHubLocation.ReadOnly]
    def string: Optional[zio.aws.codedeploy.model.RawString.ReadOnly]
    def appSpecContent
        : Optional[zio.aws.codedeploy.model.AppSpecContent.ReadOnly]
    def getRevisionType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.RevisionLocationType] =
      AwsError.unwrapOptionField("revisionType", revisionType)
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
    def getGitHubLocation
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.GitHubLocation.ReadOnly] =
      AwsError.unwrapOptionField("gitHubLocation", gitHubLocation)
    def getString
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.RawString.ReadOnly] =
      AwsError.unwrapOptionField("string", string)
    def getAppSpecContent
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.AppSpecContent.ReadOnly] =
      AwsError.unwrapOptionField("appSpecContent", appSpecContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RevisionLocation
  ) extends zio.aws.codedeploy.model.RevisionLocation.ReadOnly {
    override val revisionType
        : Optional[zio.aws.codedeploy.model.RevisionLocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionType())
        .map(value => zio.aws.codedeploy.model.RevisionLocationType.wrap(value))
    override val s3Location
        : Optional[zio.aws.codedeploy.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.codedeploy.model.S3Location.wrap(value))
    override val gitHubLocation
        : Optional[zio.aws.codedeploy.model.GitHubLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gitHubLocation())
        .map(value => zio.aws.codedeploy.model.GitHubLocation.wrap(value))
    override val string: Optional[zio.aws.codedeploy.model.RawString.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.string())
        .map(value => zio.aws.codedeploy.model.RawString.wrap(value))
    override val appSpecContent
        : Optional[zio.aws.codedeploy.model.AppSpecContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appSpecContent())
        .map(value => zio.aws.codedeploy.model.AppSpecContent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RevisionLocation
  ): zio.aws.codedeploy.model.RevisionLocation.ReadOnly = new Wrapper(impl)
}
