package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.InstanceName
import scala.jdk.CollectionConverters._
final case class RemoveTagsFromOnPremisesInstancesRequest(
    tags: Iterable[zio.aws.codedeploy.model.Tag],
    instanceNames: Iterable[InstanceName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest = {
    import RemoveTagsFromOnPremisesInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .instanceNames(instanceNames.map { item =>
        InstanceName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest.ReadOnly =
    zio.aws.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest
      .wrap(buildAwsValue())
}
object RemoveTagsFromOnPremisesInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest =
      zio.aws.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest(
        tags.map { item =>
          item.asEditable
        },
        instanceNames
      )
    def tags: List[zio.aws.codedeploy.model.Tag.ReadOnly]
    def instanceNames: List[InstanceName]
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
    def getInstanceNames: ZIO[Any, Nothing, List[InstanceName]] =
      ZIO.succeed(instanceNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest
  ) extends zio.aws.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest.ReadOnly {
    override val tags: List[zio.aws.codedeploy.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.Tag.wrap(item)
      }
      .toList
    override val instanceNames: List[InstanceName] = impl
      .instanceNames()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.primitives.InstanceName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest
  ): zio.aws.codedeploy.model.RemoveTagsFromOnPremisesInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
