package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{
  ErrorMessage,
  DeploymentGroupName,
  DeploymentConfigName,
  ApplicationName,
  Timestamp,
  DeploymentId,
  Description,
  ExternalId,
  AdditionalDeploymentStatusInfo
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DeploymentInfo(
    applicationName: Optional[ApplicationName] = Optional.Absent,
    deploymentGroupName: Optional[DeploymentGroupName] = Optional.Absent,
    deploymentConfigName: Optional[DeploymentConfigName] = Optional.Absent,
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    previousRevision: Optional[zio.aws.codedeploy.model.RevisionLocation] =
      Optional.Absent,
    revision: Optional[zio.aws.codedeploy.model.RevisionLocation] =
      Optional.Absent,
    status: Optional[zio.aws.codedeploy.model.DeploymentStatus] =
      Optional.Absent,
    errorInformation: Optional[zio.aws.codedeploy.model.ErrorInformation] =
      Optional.Absent,
    createTime: Optional[Timestamp] = Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    completeTime: Optional[Timestamp] = Optional.Absent,
    deploymentOverview: Optional[zio.aws.codedeploy.model.DeploymentOverview] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    creator: Optional[zio.aws.codedeploy.model.DeploymentCreator] =
      Optional.Absent,
    ignoreApplicationStopFailures: Optional[Boolean] = Optional.Absent,
    autoRollbackConfiguration: Optional[
      zio.aws.codedeploy.model.AutoRollbackConfiguration
    ] = Optional.Absent,
    updateOutdatedInstancesOnly: Optional[Boolean] = Optional.Absent,
    rollbackInfo: Optional[zio.aws.codedeploy.model.RollbackInfo] =
      Optional.Absent,
    deploymentStyle: Optional[zio.aws.codedeploy.model.DeploymentStyle] =
      Optional.Absent,
    targetInstances: Optional[zio.aws.codedeploy.model.TargetInstances] =
      Optional.Absent,
    instanceTerminationWaitTimeStarted: Optional[Boolean] = Optional.Absent,
    blueGreenDeploymentConfiguration: Optional[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration
    ] = Optional.Absent,
    loadBalancerInfo: Optional[zio.aws.codedeploy.model.LoadBalancerInfo] =
      Optional.Absent,
    additionalDeploymentStatusInfo: Optional[AdditionalDeploymentStatusInfo] =
      Optional.Absent,
    fileExistsBehavior: Optional[zio.aws.codedeploy.model.FileExistsBehavior] =
      Optional.Absent,
    deploymentStatusMessages: Optional[Iterable[ErrorMessage]] =
      Optional.Absent,
    computePlatform: Optional[zio.aws.codedeploy.model.ComputePlatform] =
      Optional.Absent,
    externalId: Optional[ExternalId] = Optional.Absent,
    relatedDeployments: Optional[zio.aws.codedeploy.model.RelatedDeployments] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeploymentInfo = {
    import DeploymentInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeploymentInfo
      .builder()
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        deploymentGroupName.map(value =>
          DeploymentGroupName.unwrap(value): java.lang.String
        )
      )(_.deploymentGroupName)
      .optionallyWith(
        deploymentConfigName.map(value =>
          DeploymentConfigName.unwrap(value): java.lang.String
        )
      )(_.deploymentConfigName)
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(previousRevision.map(value => value.buildAwsValue()))(
        _.previousRevision
      )
      .optionallyWith(revision.map(value => value.buildAwsValue()))(_.revision)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorInformation.map(value => value.buildAwsValue()))(
        _.errorInformation
      )
      .optionallyWith(
        createTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        completeTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completeTime)
      .optionallyWith(deploymentOverview.map(value => value.buildAwsValue()))(
        _.deploymentOverview
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(creator.map(value => value.unwrap))(_.creator)
      .optionallyWith(
        ignoreApplicationStopFailures.map(value => value: java.lang.Boolean)
      )(_.ignoreApplicationStopFailures)
      .optionallyWith(
        autoRollbackConfiguration.map(value => value.buildAwsValue())
      )(_.autoRollbackConfiguration)
      .optionallyWith(
        updateOutdatedInstancesOnly.map(value => value: java.lang.Boolean)
      )(_.updateOutdatedInstancesOnly)
      .optionallyWith(rollbackInfo.map(value => value.buildAwsValue()))(
        _.rollbackInfo
      )
      .optionallyWith(deploymentStyle.map(value => value.buildAwsValue()))(
        _.deploymentStyle
      )
      .optionallyWith(targetInstances.map(value => value.buildAwsValue()))(
        _.targetInstances
      )
      .optionallyWith(
        instanceTerminationWaitTimeStarted.map(value =>
          value: java.lang.Boolean
        )
      )(_.instanceTerminationWaitTimeStarted)
      .optionallyWith(
        blueGreenDeploymentConfiguration.map(value => value.buildAwsValue())
      )(_.blueGreenDeploymentConfiguration)
      .optionallyWith(loadBalancerInfo.map(value => value.buildAwsValue()))(
        _.loadBalancerInfo
      )
      .optionallyWith(
        additionalDeploymentStatusInfo.map(value =>
          AdditionalDeploymentStatusInfo.unwrap(value): java.lang.String
        )
      )(_.additionalDeploymentStatusInfo)
      .optionallyWith(fileExistsBehavior.map(value => value.unwrap))(
        _.fileExistsBehavior
      )
      .optionallyWith(
        deploymentStatusMessages.map(value =>
          value.map { item =>
            ErrorMessage.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deploymentStatusMessages)
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .optionallyWith(
        externalId.map(value => ExternalId.unwrap(value): java.lang.String)
      )(_.externalId)
      .optionallyWith(relatedDeployments.map(value => value.buildAwsValue()))(
        _.relatedDeployments
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.DeploymentInfo.ReadOnly =
    zio.aws.codedeploy.model.DeploymentInfo.wrap(buildAwsValue())
}
object DeploymentInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeploymentInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.DeploymentInfo =
      zio.aws.codedeploy.model.DeploymentInfo(
        applicationName.map(value => value),
        deploymentGroupName.map(value => value),
        deploymentConfigName.map(value => value),
        deploymentId.map(value => value),
        previousRevision.map(value => value.asEditable),
        revision.map(value => value.asEditable),
        status.map(value => value),
        errorInformation.map(value => value.asEditable),
        createTime.map(value => value),
        startTime.map(value => value),
        completeTime.map(value => value),
        deploymentOverview.map(value => value.asEditable),
        description.map(value => value),
        creator.map(value => value),
        ignoreApplicationStopFailures.map(value => value),
        autoRollbackConfiguration.map(value => value.asEditable),
        updateOutdatedInstancesOnly.map(value => value),
        rollbackInfo.map(value => value.asEditable),
        deploymentStyle.map(value => value.asEditable),
        targetInstances.map(value => value.asEditable),
        instanceTerminationWaitTimeStarted.map(value => value),
        blueGreenDeploymentConfiguration.map(value => value.asEditable),
        loadBalancerInfo.map(value => value.asEditable),
        additionalDeploymentStatusInfo.map(value => value),
        fileExistsBehavior.map(value => value),
        deploymentStatusMessages.map(value => value),
        computePlatform.map(value => value),
        externalId.map(value => value),
        relatedDeployments.map(value => value.asEditable)
      )
    def applicationName: Optional[ApplicationName]
    def deploymentGroupName: Optional[DeploymentGroupName]
    def deploymentConfigName: Optional[DeploymentConfigName]
    def deploymentId: Optional[DeploymentId]
    def previousRevision
        : Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
    def revision: Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly]
    def status: Optional[zio.aws.codedeploy.model.DeploymentStatus]
    def errorInformation
        : Optional[zio.aws.codedeploy.model.ErrorInformation.ReadOnly]
    def createTime: Optional[Timestamp]
    def startTime: Optional[Timestamp]
    def completeTime: Optional[Timestamp]
    def deploymentOverview
        : Optional[zio.aws.codedeploy.model.DeploymentOverview.ReadOnly]
    def description: Optional[Description]
    def creator: Optional[zio.aws.codedeploy.model.DeploymentCreator]
    def ignoreApplicationStopFailures: Optional[Boolean]
    def autoRollbackConfiguration
        : Optional[zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly]
    def updateOutdatedInstancesOnly: Optional[Boolean]
    def rollbackInfo: Optional[zio.aws.codedeploy.model.RollbackInfo.ReadOnly]
    def deploymentStyle
        : Optional[zio.aws.codedeploy.model.DeploymentStyle.ReadOnly]
    def targetInstances
        : Optional[zio.aws.codedeploy.model.TargetInstances.ReadOnly]
    def instanceTerminationWaitTimeStarted: Optional[Boolean]
    def blueGreenDeploymentConfiguration: Optional[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ]
    def loadBalancerInfo
        : Optional[zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly]
    def additionalDeploymentStatusInfo: Optional[AdditionalDeploymentStatusInfo]
    def fileExistsBehavior
        : Optional[zio.aws.codedeploy.model.FileExistsBehavior]
    def deploymentStatusMessages: Optional[List[ErrorMessage]]
    def computePlatform: Optional[zio.aws.codedeploy.model.ComputePlatform]
    def externalId: Optional[ExternalId]
    def relatedDeployments
        : Optional[zio.aws.codedeploy.model.RelatedDeployments.ReadOnly]
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getDeploymentGroupName: ZIO[Any, AwsError, DeploymentGroupName] =
      AwsError.unwrapOptionField("deploymentGroupName", deploymentGroupName)
    def getDeploymentConfigName: ZIO[Any, AwsError, DeploymentConfigName] =
      AwsError.unwrapOptionField("deploymentConfigName", deploymentConfigName)
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getPreviousRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = AwsError.unwrapOptionField("previousRevision", previousRevision)
    def getRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RevisionLocation.ReadOnly
    ] = AwsError.unwrapOptionField("revision", revision)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorInformation: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.ErrorInformation.ReadOnly
    ] = AwsError.unwrapOptionField("errorInformation", errorInformation)
    def getCreateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getCompleteTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completeTime", completeTime)
    def getDeploymentOverview: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.DeploymentOverview.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentOverview", deploymentOverview)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreator
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentCreator] =
      AwsError.unwrapOptionField("creator", creator)
    def getIgnoreApplicationStopFailures: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "ignoreApplicationStopFailures",
        ignoreApplicationStopFailures
      )
    def getAutoRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoRollbackConfiguration",
      autoRollbackConfiguration
    )
    def getUpdateOutdatedInstancesOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "updateOutdatedInstancesOnly",
        updateOutdatedInstancesOnly
      )
    def getRollbackInfo
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.RollbackInfo.ReadOnly] =
      AwsError.unwrapOptionField("rollbackInfo", rollbackInfo)
    def getDeploymentStyle: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.DeploymentStyle.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentStyle", deploymentStyle)
    def getTargetInstances: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TargetInstances.ReadOnly
    ] = AwsError.unwrapOptionField("targetInstances", targetInstances)
    def getInstanceTerminationWaitTimeStarted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "instanceTerminationWaitTimeStarted",
        instanceTerminationWaitTimeStarted
      )
    def getBlueGreenDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "blueGreenDeploymentConfiguration",
      blueGreenDeploymentConfiguration
    )
    def getLoadBalancerInfo: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly
    ] = AwsError.unwrapOptionField("loadBalancerInfo", loadBalancerInfo)
    def getAdditionalDeploymentStatusInfo
        : ZIO[Any, AwsError, AdditionalDeploymentStatusInfo] =
      AwsError.unwrapOptionField(
        "additionalDeploymentStatusInfo",
        additionalDeploymentStatusInfo
      )
    def getFileExistsBehavior
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.FileExistsBehavior] =
      AwsError.unwrapOptionField("fileExistsBehavior", fileExistsBehavior)
    def getDeploymentStatusMessages: ZIO[Any, AwsError, List[ErrorMessage]] =
      AwsError.unwrapOptionField(
        "deploymentStatusMessages",
        deploymentStatusMessages
      )
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
    def getExternalId: ZIO[Any, AwsError, ExternalId] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getRelatedDeployments: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.RelatedDeployments.ReadOnly
    ] = AwsError.unwrapOptionField("relatedDeployments", relatedDeployments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentInfo
  ) extends zio.aws.codedeploy.model.DeploymentInfo.ReadOnly {
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.ApplicationName(value)
        )
    override val deploymentGroupName: Optional[DeploymentGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentGroupName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.DeploymentGroupName(value)
        )
    override val deploymentConfigName: Optional[DeploymentConfigName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfigName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.DeploymentConfigName(value)
        )
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val previousRevision
        : Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previousRevision())
        .map(value => zio.aws.codedeploy.model.RevisionLocation.wrap(value))
    override val revision
        : Optional[zio.aws.codedeploy.model.RevisionLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revision())
        .map(value => zio.aws.codedeploy.model.RevisionLocation.wrap(value))
    override val status: Optional[zio.aws.codedeploy.model.DeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codedeploy.model.DeploymentStatus.wrap(value))
    override val errorInformation
        : Optional[zio.aws.codedeploy.model.ErrorInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorInformation())
        .map(value => zio.aws.codedeploy.model.ErrorInformation.wrap(value))
    override val createTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val completeTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completeTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val deploymentOverview
        : Optional[zio.aws.codedeploy.model.DeploymentOverview.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentOverview())
        .map(value => zio.aws.codedeploy.model.DeploymentOverview.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codedeploy.model.primitives.Description(value))
    override val creator: Optional[zio.aws.codedeploy.model.DeploymentCreator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creator())
        .map(value => zio.aws.codedeploy.model.DeploymentCreator.wrap(value))
    override val ignoreApplicationStopFailures: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ignoreApplicationStopFailures())
        .map(value => value: Boolean)
    override val autoRollbackConfiguration: Optional[
      zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.autoRollbackConfiguration())
      .map(value =>
        zio.aws.codedeploy.model.AutoRollbackConfiguration.wrap(value)
      )
    override val updateOutdatedInstancesOnly: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateOutdatedInstancesOnly())
        .map(value => value: Boolean)
    override val rollbackInfo
        : Optional[zio.aws.codedeploy.model.RollbackInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rollbackInfo())
        .map(value => zio.aws.codedeploy.model.RollbackInfo.wrap(value))
    override val deploymentStyle
        : Optional[zio.aws.codedeploy.model.DeploymentStyle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStyle())
        .map(value => zio.aws.codedeploy.model.DeploymentStyle.wrap(value))
    override val targetInstances
        : Optional[zio.aws.codedeploy.model.TargetInstances.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetInstances())
        .map(value => zio.aws.codedeploy.model.TargetInstances.wrap(value))
    override val instanceTerminationWaitTimeStarted: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTerminationWaitTimeStarted())
        .map(value => value: Boolean)
    override val blueGreenDeploymentConfiguration: Optional[
      zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blueGreenDeploymentConfiguration())
      .map(value =>
        zio.aws.codedeploy.model.BlueGreenDeploymentConfiguration.wrap(value)
      )
    override val loadBalancerInfo
        : Optional[zio.aws.codedeploy.model.LoadBalancerInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerInfo())
        .map(value => zio.aws.codedeploy.model.LoadBalancerInfo.wrap(value))
    override val additionalDeploymentStatusInfo
        : Optional[AdditionalDeploymentStatusInfo] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalDeploymentStatusInfo())
      .map(value =>
        zio.aws.codedeploy.model.primitives
          .AdditionalDeploymentStatusInfo(value)
      )
    override val fileExistsBehavior
        : Optional[zio.aws.codedeploy.model.FileExistsBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileExistsBehavior())
        .map(value => zio.aws.codedeploy.model.FileExistsBehavior.wrap(value))
    override val deploymentStatusMessages: Optional[List[ErrorMessage]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.primitives.ErrorMessage(item)
          }.toList
        )
    override val computePlatform
        : Optional[zio.aws.codedeploy.model.ComputePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computePlatform())
        .map(value => zio.aws.codedeploy.model.ComputePlatform.wrap(value))
    override val externalId: Optional[ExternalId] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.codedeploy.model.primitives.ExternalId(value))
    override val relatedDeployments
        : Optional[zio.aws.codedeploy.model.RelatedDeployments.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedDeployments())
        .map(value => zio.aws.codedeploy.model.RelatedDeployments.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeploymentInfo
  ): zio.aws.codedeploy.model.DeploymentInfo.ReadOnly = new Wrapper(impl)
}
