package zio.aws.codedeploy
import zio.aws.codedeploy.model.ListDeploymentsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.codedeploy.model.{
  StopDeploymentRequest,
  UpdateApplicationRequest,
  BatchGetApplicationRevisionsRequest,
  ListGitHubAccountTokenNamesRequest,
  RegisterOnPremisesInstanceRequest,
  DeleteApplicationRequest,
  DeleteDeploymentConfigRequest,
  BatchGetDeploymentTargetsRequest,
  ListDeploymentTargetsRequest,
  BatchGetApplicationsRequest,
  CreateDeploymentConfigRequest,
  UpdateDeploymentGroupRequest,
  CreateApplicationRequest,
  ListDeploymentGroupsRequest,
  ListTagsForResourceRequest,
  DeleteResourcesByExternalIdRequest,
  DeleteGitHubAccountTokenRequest,
  CreateDeploymentGroupRequest,
  GetApplicationRevisionRequest,
  DeleteDeploymentGroupRequest,
  GetDeploymentGroupRequest,
  ListOnPremisesInstancesRequest,
  ListDeploymentsRequest,
  GetApplicationRequest,
  AddTagsToOnPremisesInstancesRequest,
  ListDeploymentConfigsRequest,
  UntagResourceRequest,
  ListApplicationRevisionsRequest,
  ListApplicationsRequest,
  ContinueDeploymentRequest,
  RegisterApplicationRevisionRequest,
  CreateDeploymentRequest,
  BatchGetOnPremisesInstancesRequest,
  GetDeploymentRequest,
  RemoveTagsFromOnPremisesInstancesRequest,
  GetDeploymentTargetRequest,
  BatchGetDeploymentsRequest,
  BatchGetDeploymentGroupsRequest,
  PutLifecycleEventHookExecutionStatusRequest,
  TagResourceRequest,
  GetOnPremisesInstanceRequest,
  GetDeploymentConfigRequest,
  DeregisterOnPremisesInstanceRequest
}
import zio.aws.codedeploy.model.primitives.{
  ApplicationName,
  DeploymentGroupName,
  DeploymentId,
  DeploymentConfigName
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient
import zio.stream.ZStream
object CodeDeployMock extends Mock[CodeDeploy] {
  object RemoveTagsFromOnPremisesInstances
      extends Effect[RemoveTagsFromOnPremisesInstancesRequest, AwsError, Unit]
  object StopDeployment
      extends Effect[
        StopDeploymentRequest,
        AwsError,
        zio.aws.codedeploy.model.StopDeploymentResponse.ReadOnly
      ]
  object GetApplication
      extends Effect[
        GetApplicationRequest,
        AwsError,
        zio.aws.codedeploy.model.GetApplicationResponse.ReadOnly
      ]
  object ListDeploymentConfigs
      extends Stream[
        ListDeploymentConfigsRequest,
        AwsError,
        DeploymentConfigName
      ]
  object ListDeploymentConfigsPaginated
      extends Effect[
        ListDeploymentConfigsRequest,
        AwsError,
        zio.aws.codedeploy.model.ListDeploymentConfigsResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[DeleteApplicationRequest, AwsError, Unit]
  object ListOnPremisesInstances
      extends Effect[
        ListOnPremisesInstancesRequest,
        AwsError,
        zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.ReadOnly
      ]
  object ContinueDeployment
      extends Effect[ContinueDeploymentRequest, AwsError, Unit]
  object UpdateDeploymentGroup
      extends Effect[
        UpdateDeploymentGroupRequest,
        AwsError,
        zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.ReadOnly
      ]
  object DeleteResourcesByExternalId
      extends Effect[
        DeleteResourcesByExternalIdRequest,
        AwsError,
        zio.aws.codedeploy.model.DeleteResourcesByExternalIdResponse.ReadOnly
      ]
  object ListGitHubAccountTokenNames
      extends Effect[
        ListGitHubAccountTokenNamesRequest,
        AwsError,
        zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.ReadOnly
      ]
  object GetDeployment
      extends Effect[
        GetDeploymentRequest,
        AwsError,
        zio.aws.codedeploy.model.GetDeploymentResponse.ReadOnly
      ]
  object CreateDeploymentConfig
      extends Effect[
        CreateDeploymentConfigRequest,
        AwsError,
        zio.aws.codedeploy.model.CreateDeploymentConfigResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.codedeploy.model.CreateApplicationResponse.ReadOnly
      ]
  object ListApplicationRevisions
      extends Stream[
        ListApplicationRevisionsRequest,
        AwsError,
        zio.aws.codedeploy.model.RevisionLocation.ReadOnly
      ]
  object ListApplicationRevisionsPaginated
      extends Effect[
        ListApplicationRevisionsRequest,
        AwsError,
        zio.aws.codedeploy.model.ListApplicationRevisionsResponse.ReadOnly
      ]
  object RegisterOnPremisesInstance
      extends Effect[RegisterOnPremisesInstanceRequest, AwsError, Unit]
  object DeleteDeploymentConfig
      extends Effect[DeleteDeploymentConfigRequest, AwsError, Unit]
  object ListDeployments
      extends Stream[ListDeploymentsRequest, AwsError, DeploymentId]
  object ListDeploymentsPaginated
      extends Effect[ListDeploymentsRequest, AwsError, ReadOnly]
  object GetDeploymentConfig
      extends Effect[
        GetDeploymentConfigRequest,
        AwsError,
        zio.aws.codedeploy.model.GetDeploymentConfigResponse.ReadOnly
      ]
  object DeregisterOnPremisesInstance
      extends Effect[DeregisterOnPremisesInstanceRequest, AwsError, Unit]
  object GetDeploymentGroup
      extends Effect[
        GetDeploymentGroupRequest,
        AwsError,
        zio.aws.codedeploy.model.GetDeploymentGroupResponse.ReadOnly
      ]
  object AddTagsToOnPremisesInstances
      extends Effect[AddTagsToOnPremisesInstancesRequest, AwsError, Unit]
  object ListDeploymentGroups
      extends Stream[ListDeploymentGroupsRequest, AwsError, DeploymentGroupName]
  object ListDeploymentGroupsPaginated
      extends Effect[
        ListDeploymentGroupsRequest,
        AwsError,
        zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.codedeploy.model.UntagResourceResponse.ReadOnly
      ]
  object GetApplicationRevision
      extends Effect[
        GetApplicationRevisionRequest,
        AwsError,
        zio.aws.codedeploy.model.GetApplicationRevisionResponse.ReadOnly
      ]
  object CreateDeployment
      extends Effect[
        CreateDeploymentRequest,
        AwsError,
        zio.aws.codedeploy.model.CreateDeploymentResponse.ReadOnly
      ]
  object RegisterApplicationRevision
      extends Effect[RegisterApplicationRevisionRequest, AwsError, Unit]
  object BatchGetApplications
      extends Effect[
        BatchGetApplicationsRequest,
        AwsError,
        zio.aws.codedeploy.model.BatchGetApplicationsResponse.ReadOnly
      ]
  object DeleteGitHubAccountToken
      extends Effect[
        DeleteGitHubAccountTokenRequest,
        AwsError,
        zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.ReadOnly
      ]
  object DeleteDeploymentGroup
      extends Effect[
        DeleteDeploymentGroupRequest,
        AwsError,
        zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codedeploy.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codedeploy.model.ListTagsForResourceResponse.ReadOnly
      ]
  object BatchGetApplicationRevisions
      extends Effect[
        BatchGetApplicationRevisionsRequest,
        AwsError,
        zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.ReadOnly
      ]
  object GetOnPremisesInstance
      extends Effect[
        GetOnPremisesInstanceRequest,
        AwsError,
        zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.codedeploy.model.TagResourceResponse.ReadOnly
      ]
  object GetDeploymentTarget
      extends Effect[
        GetDeploymentTargetRequest,
        AwsError,
        zio.aws.codedeploy.model.GetDeploymentTargetResponse.ReadOnly
      ]
  object ListApplications
      extends Stream[ListApplicationsRequest, AwsError, ApplicationName]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.codedeploy.model.ListApplicationsResponse.ReadOnly
      ]
  object BatchGetDeploymentGroups
      extends Effect[
        BatchGetDeploymentGroupsRequest,
        AwsError,
        zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.ReadOnly
      ]
  object ListDeploymentTargets
      extends Effect[
        ListDeploymentTargetsRequest,
        AwsError,
        zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly
      ]
  object BatchGetOnPremisesInstances
      extends Effect[
        BatchGetOnPremisesInstancesRequest,
        AwsError,
        zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[UpdateApplicationRequest, AwsError, Unit]
  object BatchGetDeploymentTargets
      extends Effect[
        BatchGetDeploymentTargetsRequest,
        AwsError,
        zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.ReadOnly
      ]
  object BatchGetDeployments
      extends Effect[
        BatchGetDeploymentsRequest,
        AwsError,
        zio.aws.codedeploy.model.BatchGetDeploymentsResponse.ReadOnly
      ]
  object PutLifecycleEventHookExecutionStatus
      extends Effect[
        PutLifecycleEventHookExecutionStatusRequest,
        AwsError,
        zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.ReadOnly
      ]
  object CreateDeploymentGroup
      extends Effect[
        CreateDeploymentGroupRequest,
        AwsError,
        zio.aws.codedeploy.model.CreateDeploymentGroupResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodeDeploy] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodeDeploy] { rts =>
        zio.ZIO.succeed {
          new CodeDeploy {
            val api: CodeDeployAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodeDeploy = this
            def removeTagsFromOnPremisesInstances(
                request: RemoveTagsFromOnPremisesInstancesRequest
            ): IO[AwsError, Unit] =
              proxy(RemoveTagsFromOnPremisesInstances, request)
            def stopDeployment(request: StopDeploymentRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.StopDeploymentResponse.ReadOnly
            ] = proxy(StopDeployment, request)
            def getApplication(request: GetApplicationRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.GetApplicationResponse.ReadOnly
            ] = proxy(GetApplication, request)
            def listDeploymentConfigs(
                request: ListDeploymentConfigsRequest
            ): ZStream[Any, AwsError, DeploymentConfigName] =
              rts.unsafeRun(proxy(ListDeploymentConfigs, request))
            def listDeploymentConfigsPaginated(
                request: ListDeploymentConfigsRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.ListDeploymentConfigsResponse.ReadOnly
            ] = proxy(ListDeploymentConfigsPaginated, request)
            def deleteApplication(
                request: DeleteApplicationRequest
            ): IO[AwsError, Unit] = proxy(DeleteApplication, request)
            def listOnPremisesInstances(
                request: ListOnPremisesInstancesRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.ListOnPremisesInstancesResponse.ReadOnly
            ] = proxy(ListOnPremisesInstances, request)
            def continueDeployment(
                request: ContinueDeploymentRequest
            ): IO[AwsError, Unit] = proxy(ContinueDeployment, request)
            def updateDeploymentGroup(
                request: UpdateDeploymentGroupRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.UpdateDeploymentGroupResponse.ReadOnly
            ] = proxy(UpdateDeploymentGroup, request)
            def deleteResourcesByExternalId(
                request: DeleteResourcesByExternalIdRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.DeleteResourcesByExternalIdResponse.ReadOnly
            ] = proxy(DeleteResourcesByExternalId, request)
            def listGitHubAccountTokenNames(
                request: ListGitHubAccountTokenNamesRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.ListGitHubAccountTokenNamesResponse.ReadOnly
            ] = proxy(ListGitHubAccountTokenNames, request)
            def getDeployment(request: GetDeploymentRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.GetDeploymentResponse.ReadOnly
            ] = proxy(GetDeployment, request)
            def createDeploymentConfig(
                request: CreateDeploymentConfigRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.CreateDeploymentConfigResponse.ReadOnly
            ] = proxy(CreateDeploymentConfig, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def listApplicationRevisions(
                request: ListApplicationRevisionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codedeploy.model.RevisionLocation.ReadOnly
            ] = rts.unsafeRun(proxy(ListApplicationRevisions, request))
            def listApplicationRevisionsPaginated(
                request: ListApplicationRevisionsRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.ListApplicationRevisionsResponse.ReadOnly
            ] = proxy(ListApplicationRevisionsPaginated, request)
            def registerOnPremisesInstance(
                request: RegisterOnPremisesInstanceRequest
            ): IO[AwsError, Unit] = proxy(RegisterOnPremisesInstance, request)
            def deleteDeploymentConfig(
                request: DeleteDeploymentConfigRequest
            ): IO[AwsError, Unit] = proxy(DeleteDeploymentConfig, request)
            def listDeployments(
                request: ListDeploymentsRequest
            ): ZStream[Any, AwsError, DeploymentId] =
              rts.unsafeRun(proxy(ListDeployments, request))
            def listDeploymentsPaginated(
                request: ListDeploymentsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListDeploymentsPaginated, request)
            def getDeploymentConfig(request: GetDeploymentConfigRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.GetDeploymentConfigResponse.ReadOnly
            ] = proxy(GetDeploymentConfig, request)
            def deregisterOnPremisesInstance(
                request: DeregisterOnPremisesInstanceRequest
            ): IO[AwsError, Unit] = proxy(DeregisterOnPremisesInstance, request)
            def getDeploymentGroup(request: GetDeploymentGroupRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.GetDeploymentGroupResponse.ReadOnly
            ] = proxy(GetDeploymentGroup, request)
            def addTagsToOnPremisesInstances(
                request: AddTagsToOnPremisesInstancesRequest
            ): IO[AwsError, Unit] = proxy(AddTagsToOnPremisesInstances, request)
            def listDeploymentGroups(
                request: ListDeploymentGroupsRequest
            ): ZStream[Any, AwsError, DeploymentGroupName] =
              rts.unsafeRun(proxy(ListDeploymentGroups, request))
            def listDeploymentGroupsPaginated(
                request: ListDeploymentGroupsRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.ListDeploymentGroupsResponse.ReadOnly
            ] = proxy(ListDeploymentGroupsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getApplicationRevision(
                request: GetApplicationRevisionRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.GetApplicationRevisionResponse.ReadOnly
            ] = proxy(GetApplicationRevision, request)
            def createDeployment(request: CreateDeploymentRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.CreateDeploymentResponse.ReadOnly
            ] = proxy(CreateDeployment, request)
            def registerApplicationRevision(
                request: RegisterApplicationRevisionRequest
            ): IO[AwsError, Unit] = proxy(RegisterApplicationRevision, request)
            def batchGetApplications(request: BatchGetApplicationsRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.BatchGetApplicationsResponse.ReadOnly
            ] = proxy(BatchGetApplications, request)
            def deleteGitHubAccountToken(
                request: DeleteGitHubAccountTokenRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.DeleteGitHubAccountTokenResponse.ReadOnly
            ] = proxy(DeleteGitHubAccountToken, request)
            def deleteDeploymentGroup(
                request: DeleteDeploymentGroupRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.DeleteDeploymentGroupResponse.ReadOnly
            ] = proxy(DeleteDeploymentGroup, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.codedeploy.model.Tag.ReadOnly] =
              rts.unsafeRun(proxy(ListTagsForResource, request))
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def batchGetApplicationRevisions(
                request: BatchGetApplicationRevisionsRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.BatchGetApplicationRevisionsResponse.ReadOnly
            ] = proxy(BatchGetApplicationRevisions, request)
            def getOnPremisesInstance(
                request: GetOnPremisesInstanceRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.GetOnPremisesInstanceResponse.ReadOnly
            ] = proxy(GetOnPremisesInstance, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getDeploymentTarget(request: GetDeploymentTargetRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.GetDeploymentTargetResponse.ReadOnly
            ] = proxy(GetDeploymentTarget, request)
            def listApplications(
                request: ListApplicationsRequest
            ): ZStream[Any, AwsError, ApplicationName] =
              rts.unsafeRun(proxy(ListApplications, request))
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def batchGetDeploymentGroups(
                request: BatchGetDeploymentGroupsRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.BatchGetDeploymentGroupsResponse.ReadOnly
            ] = proxy(BatchGetDeploymentGroups, request)
            def listDeploymentTargets(
                request: ListDeploymentTargetsRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.ListDeploymentTargetsResponse.ReadOnly
            ] = proxy(ListDeploymentTargets, request)
            def batchGetOnPremisesInstances(
                request: BatchGetOnPremisesInstancesRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.BatchGetOnPremisesInstancesResponse.ReadOnly
            ] = proxy(BatchGetOnPremisesInstances, request)
            def updateApplication(
                request: UpdateApplicationRequest
            ): IO[AwsError, Unit] = proxy(UpdateApplication, request)
            def batchGetDeploymentTargets(
                request: BatchGetDeploymentTargetsRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.BatchGetDeploymentTargetsResponse.ReadOnly
            ] = proxy(BatchGetDeploymentTargets, request)
            def batchGetDeployments(request: BatchGetDeploymentsRequest): IO[
              AwsError,
              zio.aws.codedeploy.model.BatchGetDeploymentsResponse.ReadOnly
            ] = proxy(BatchGetDeployments, request)
            def putLifecycleEventHookExecutionStatus(
                request: PutLifecycleEventHookExecutionStatusRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusResponse.ReadOnly
            ] = proxy(PutLifecycleEventHookExecutionStatus, request)
            def createDeploymentGroup(
                request: CreateDeploymentGroupRequest
            ): IO[
              AwsError,
              zio.aws.codedeploy.model.CreateDeploymentGroupResponse.ReadOnly
            ] = proxy(CreateDeploymentGroup, request)
          }
        }
      }
    }
  }
}
