package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait OutdatedInstancesStrategy {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy
}
object OutdatedInstancesStrategy {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy
  ): zio.aws.codedeploy.model.OutdatedInstancesStrategy = value match {
    case software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy.UPDATE =>
      val r = UPDATE
      r
    case software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy.IGNORE =>
      val r = IGNORE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.OutdatedInstancesStrategy {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy =
      software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object UPDATE
      extends zio.aws.codedeploy.model.OutdatedInstancesStrategy {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy =
      software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy.UPDATE
  }
  case object IGNORE
      extends zio.aws.codedeploy.model.OutdatedInstancesStrategy {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy =
      software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy.IGNORE
  }
}
