package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.DeploymentId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContinueDeploymentRequest(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    deploymentWaitType: Optional[zio.aws.codedeploy.model.DeploymentWaitType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest = {
    import ContinueDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(deploymentWaitType.map(value => value.unwrap))(
        _.deploymentWaitType
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ContinueDeploymentRequest.ReadOnly =
    zio.aws.codedeploy.model.ContinueDeploymentRequest.wrap(buildAwsValue())
}
object ContinueDeploymentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ContinueDeploymentRequest =
      zio.aws.codedeploy.model.ContinueDeploymentRequest(
        deploymentId.map(value => value),
        deploymentWaitType.map(value => value)
      )
    def deploymentId: Optional[DeploymentId]
    def deploymentWaitType
        : Optional[zio.aws.codedeploy.model.DeploymentWaitType]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getDeploymentWaitType
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentWaitType] =
      AwsError.unwrapOptionField("deploymentWaitType", deploymentWaitType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest
  ) extends zio.aws.codedeploy.model.ContinueDeploymentRequest.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val deploymentWaitType
        : Optional[zio.aws.codedeploy.model.DeploymentWaitType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentWaitType())
        .map(value => zio.aws.codedeploy.model.DeploymentWaitType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ContinueDeploymentRequest
  ): zio.aws.codedeploy.model.ContinueDeploymentRequest.ReadOnly = new Wrapper(
    impl
  )
}
