package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{
  Time,
  TargetArn,
  TargetId,
  DeploymentId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ECSTarget(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    targetId: Optional[TargetId] = Optional.Absent,
    targetArn: Optional[TargetArn] = Optional.Absent,
    lastUpdatedAt: Optional[Time] = Optional.Absent,
    lifecycleEvents: Optional[
      Iterable[zio.aws.codedeploy.model.LifecycleEvent]
    ] = Optional.Absent,
    status: Optional[zio.aws.codedeploy.model.TargetStatus] = Optional.Absent,
    taskSetsInfo: Optional[Iterable[zio.aws.codedeploy.model.ECSTaskSet]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ECSTarget = {
    import ECSTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ECSTarget
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(
        targetArn.map(value => TargetArn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(lastUpdatedAt.map(value => Time.unwrap(value): Instant))(
        _.lastUpdatedAt
      )
      .optionallyWith(
        lifecycleEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecycleEvents)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        taskSetsInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskSetsInfo)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ECSTarget.ReadOnly =
    zio.aws.codedeploy.model.ECSTarget.wrap(buildAwsValue())
}
object ECSTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ECSTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ECSTarget =
      zio.aws.codedeploy.model.ECSTarget(
        deploymentId.map(value => value),
        targetId.map(value => value),
        targetArn.map(value => value),
        lastUpdatedAt.map(value => value),
        lifecycleEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        taskSetsInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deploymentId: Optional[DeploymentId]
    def targetId: Optional[TargetId]
    def targetArn: Optional[TargetArn]
    def lastUpdatedAt: Optional[Time]
    def lifecycleEvents
        : Optional[List[zio.aws.codedeploy.model.LifecycleEvent.ReadOnly]]
    def status: Optional[zio.aws.codedeploy.model.TargetStatus]
    def taskSetsInfo
        : Optional[List[zio.aws.codedeploy.model.ECSTaskSet.ReadOnly]]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getTargetArn: ZIO[Any, AwsError, TargetArn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getLastUpdatedAt: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getLifecycleEvents: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.LifecycleEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("lifecycleEvents", lifecycleEvents)
    def getStatus: ZIO[Any, AwsError, zio.aws.codedeploy.model.TargetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTaskSetsInfo: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.ECSTaskSet.ReadOnly
    ]] = AwsError.unwrapOptionField("taskSetsInfo", taskSetsInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ECSTarget
  ) extends zio.aws.codedeploy.model.ECSTarget.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val targetId: Optional[TargetId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetId())
      .map(value => zio.aws.codedeploy.model.primitives.TargetId(value))
    override val targetArn: Optional[TargetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.codedeploy.model.primitives.TargetArn(value))
    override val lastUpdatedAt: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.codedeploy.model.primitives.Time(value))
    override val lifecycleEvents
        : Optional[List[zio.aws.codedeploy.model.LifecycleEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.LifecycleEvent.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.codedeploy.model.TargetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codedeploy.model.TargetStatus.wrap(value))
    override val taskSetsInfo
        : Optional[List[zio.aws.codedeploy.model.ECSTaskSet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskSetsInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.ECSTaskSet.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ECSTarget
  ): zio.aws.codedeploy.model.ECSTarget.ReadOnly = new Wrapper(impl)
}
