package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  LifecycleEventHookExecutionId,
  DeploymentId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutLifecycleEventHookExecutionStatusRequest(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    lifecycleEventHookExecutionId: Optional[LifecycleEventHookExecutionId] =
      Optional.Absent,
    status: Optional[zio.aws.codedeploy.model.LifecycleEventStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest = {
    import PutLifecycleEventHookExecutionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        lifecycleEventHookExecutionId.map(value =>
          LifecycleEventHookExecutionId.unwrap(value): java.lang.String
        )
      )(_.lifecycleEventHookExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest.ReadOnly =
    zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest
      .wrap(buildAwsValue())
}
object PutLifecycleEventHookExecutionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest =
      zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest(
        deploymentId.map(value => value),
        lifecycleEventHookExecutionId.map(value => value),
        status.map(value => value)
      )
    def deploymentId: Optional[DeploymentId]
    def lifecycleEventHookExecutionId: Optional[LifecycleEventHookExecutionId]
    def status: Optional[zio.aws.codedeploy.model.LifecycleEventStatus]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getLifecycleEventHookExecutionId
        : ZIO[Any, AwsError, LifecycleEventHookExecutionId] =
      AwsError.unwrapOptionField(
        "lifecycleEventHookExecutionId",
        lifecycleEventHookExecutionId
      )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.LifecycleEventStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest
  ) extends zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val lifecycleEventHookExecutionId
        : Optional[LifecycleEventHookExecutionId] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycleEventHookExecutionId())
      .map(value =>
        zio.aws.codedeploy.model.primitives.LifecycleEventHookExecutionId(value)
      )
    override val status
        : Optional[zio.aws.codedeploy.model.LifecycleEventStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codedeploy.model.LifecycleEventStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest
  ): zio.aws.codedeploy.model.PutLifecycleEventHookExecutionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
