package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.DeploymentConfigName
import scala.jdk.CollectionConverters._
final case class GetDeploymentConfigRequest(
    deploymentConfigName: DeploymentConfigName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest = {
    import GetDeploymentConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest
      .builder()
      .deploymentConfigName(
        DeploymentConfigName.unwrap(deploymentConfigName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.GetDeploymentConfigRequest.ReadOnly =
    zio.aws.codedeploy.model.GetDeploymentConfigRequest.wrap(buildAwsValue())
}
object GetDeploymentConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.GetDeploymentConfigRequest =
      zio.aws.codedeploy.model.GetDeploymentConfigRequest(deploymentConfigName)
    def deploymentConfigName: DeploymentConfigName
    def getDeploymentConfigName: ZIO[Any, Nothing, DeploymentConfigName] =
      ZIO.succeed(deploymentConfigName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest
  ) extends zio.aws.codedeploy.model.GetDeploymentConfigRequest.ReadOnly {
    override val deploymentConfigName: DeploymentConfigName =
      zio.aws.codedeploy.model.primitives
        .DeploymentConfigName(impl.deploymentConfigName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.GetDeploymentConfigRequest
  ): zio.aws.codedeploy.model.GetDeploymentConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
