package zio.aws.codedeploy.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.codedeploy.model.primitives.{
  GitHubAccountTokenName,
  Timestamp,
  ApplicationName,
  ApplicationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ApplicationInfo(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    applicationName: Optional[ApplicationName] = Optional.Absent,
    createTime: Optional[Timestamp] = Optional.Absent,
    linkedToGitHub: Optional[Boolean] = Optional.Absent,
    gitHubAccountName: Optional[GitHubAccountTokenName] = Optional.Absent,
    computePlatform: Optional[zio.aws.codedeploy.model.ComputePlatform] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ApplicationInfo = {
    import ApplicationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ApplicationInfo
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        applicationName.map(value =>
          ApplicationName.unwrap(value): java.lang.String
        )
      )(_.applicationName)
      .optionallyWith(
        createTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(linkedToGitHub.map(value => value: java.lang.Boolean))(
        _.linkedToGitHub
      )
      .optionallyWith(
        gitHubAccountName.map(value =>
          GitHubAccountTokenName.unwrap(value): java.lang.String
        )
      )(_.gitHubAccountName)
      .optionallyWith(computePlatform.map(value => value.unwrap))(
        _.computePlatform
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ApplicationInfo.ReadOnly =
    zio.aws.codedeploy.model.ApplicationInfo.wrap(buildAwsValue())
}
object ApplicationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ApplicationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ApplicationInfo =
      zio.aws.codedeploy.model.ApplicationInfo(
        applicationId.map(value => value),
        applicationName.map(value => value),
        createTime.map(value => value),
        linkedToGitHub.map(value => value),
        gitHubAccountName.map(value => value),
        computePlatform.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def applicationName: Optional[ApplicationName]
    def createTime: Optional[Timestamp]
    def linkedToGitHub: Optional[Boolean]
    def gitHubAccountName: Optional[GitHubAccountTokenName]
    def computePlatform: Optional[zio.aws.codedeploy.model.ComputePlatform]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getApplicationName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("applicationName", applicationName)
    def getCreateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLinkedToGitHub: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("linkedToGitHub", linkedToGitHub)
    def getGitHubAccountName: ZIO[Any, AwsError, GitHubAccountTokenName] =
      AwsError.unwrapOptionField("gitHubAccountName", gitHubAccountName)
    def getComputePlatform
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ComputePlatform] =
      AwsError.unwrapOptionField("computePlatform", computePlatform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ApplicationInfo
  ) extends zio.aws.codedeploy.model.ApplicationInfo.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.codedeploy.model.primitives.ApplicationId(value))
    override val applicationName: Optional[ApplicationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.ApplicationName(value)
        )
    override val createTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val linkedToGitHub: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.linkedToGitHub())
      .map(value => value: Boolean)
    override val gitHubAccountName: Optional[GitHubAccountTokenName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gitHubAccountName())
        .map(value =>
          zio.aws.codedeploy.model.primitives.GitHubAccountTokenName(value)
        )
    override val computePlatform
        : Optional[zio.aws.codedeploy.model.ComputePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.computePlatform())
        .map(value => zio.aws.codedeploy.model.ComputePlatform.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ApplicationInfo
  ): zio.aws.codedeploy.model.ApplicationInfo.ReadOnly = new Wrapper(impl)
}
