package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.DeploymentGroupId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDeploymentGroupResponse(
    deploymentGroupId: Optional[DeploymentGroupId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse = {
    import CreateDeploymentGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse
      .builder()
      .optionallyWith(
        deploymentGroupId.map(value =>
          DeploymentGroupId.unwrap(value): java.lang.String
        )
      )(_.deploymentGroupId)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.CreateDeploymentGroupResponse.ReadOnly =
    zio.aws.codedeploy.model.CreateDeploymentGroupResponse.wrap(buildAwsValue())
}
object CreateDeploymentGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.CreateDeploymentGroupResponse =
      zio.aws.codedeploy.model
        .CreateDeploymentGroupResponse(deploymentGroupId.map(value => value))
    def deploymentGroupId: Optional[DeploymentGroupId]
    def getDeploymentGroupId: ZIO[Any, AwsError, DeploymentGroupId] =
      AwsError.unwrapOptionField("deploymentGroupId", deploymentGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse
  ) extends zio.aws.codedeploy.model.CreateDeploymentGroupResponse.ReadOnly {
    override val deploymentGroupId: Optional[DeploymentGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentGroupId())
        .map(value =>
          zio.aws.codedeploy.model.primitives.DeploymentGroupId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.CreateDeploymentGroupResponse
  ): zio.aws.codedeploy.model.CreateDeploymentGroupResponse.ReadOnly =
    new Wrapper(impl)
}
