package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait TriggerEventType {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.TriggerEventType
}
object TriggerEventType {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.TriggerEventType
  ): zio.aws.codedeploy.model.TriggerEventType = value match {
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_START =>
      val r = DeploymentStart
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_SUCCESS =>
      val r = DeploymentSuccess
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_FAILURE =>
      val r = DeploymentFailure
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_STOP =>
      val r = DeploymentStop
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_ROLLBACK =>
      val r = DeploymentRollback
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_READY =>
      val r = DeploymentReady
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.INSTANCE_START =>
      val r = InstanceStart
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.INSTANCE_SUCCESS =>
      val r = InstanceSuccess
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.INSTANCE_FAILURE =>
      val r = InstanceFailure
      r
    case software.amazon.awssdk.services.codedeploy.model.TriggerEventType.INSTANCE_READY =>
      val r = InstanceReady
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object DeploymentStart
      extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_START
  }
  case object DeploymentSuccess
      extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_SUCCESS
  }
  case object DeploymentFailure
      extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_FAILURE
  }
  case object DeploymentStop extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_STOP
  }
  case object DeploymentRollback
      extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_ROLLBACK
  }
  case object DeploymentReady
      extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.DEPLOYMENT_READY
  }
  case object InstanceStart extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.INSTANCE_START
  }
  case object InstanceSuccess
      extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.INSTANCE_SUCCESS
  }
  case object InstanceFailure
      extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.INSTANCE_FAILURE
  }
  case object InstanceReady extends zio.aws.codedeploy.model.TriggerEventType {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.TriggerEventType =
      software.amazon.awssdk.services.codedeploy.model.TriggerEventType.INSTANCE_READY
  }
}
