package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait ListStateFilterAction {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction
}
object ListStateFilterAction {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction
  ): zio.aws.codedeploy.model.ListStateFilterAction = value match {
    case software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction.INCLUDE =>
      val r = include
      r
    case software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction.EXCLUDE =>
      val r = exclude
      r
    case software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction.IGNORE =>
      val r = ignore
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.ListStateFilterAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction =
      software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction.UNKNOWN_TO_SDK_VERSION
  }
  case object include extends zio.aws.codedeploy.model.ListStateFilterAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction =
      software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction.INCLUDE
  }
  case object exclude extends zio.aws.codedeploy.model.ListStateFilterAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction =
      software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction.EXCLUDE
  }
  case object ignore extends zio.aws.codedeploy.model.ListStateFilterAction {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction =
      software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction.IGNORE
  }
}
