package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  InstanceArn,
  IamUserArn,
  IamSessionArn,
  Timestamp,
  InstanceName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InstanceInfo(
    instanceName: Option[InstanceName] = None,
    iamSessionArn: Option[IamSessionArn] = None,
    iamUserArn: Option[IamUserArn] = None,
    instanceArn: Option[InstanceArn] = None,
    registerTime: Option[Timestamp] = None,
    deregisterTime: Option[Timestamp] = None,
    tags: Option[Iterable[zio.aws.codedeploy.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.InstanceInfo = {
    import InstanceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.InstanceInfo
      .builder()
      .optionallyWith(
        instanceName.map(value => InstanceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(
        iamSessionArn.map(value =>
          IamSessionArn.unwrap(value): java.lang.String
        )
      )(_.iamSessionArn)
      .optionallyWith(
        iamUserArn.map(value => IamUserArn.unwrap(value): java.lang.String)
      )(_.iamUserArn)
      .optionallyWith(
        instanceArn.map(value => InstanceArn.unwrap(value): java.lang.String)
      )(_.instanceArn)
      .optionallyWith(
        registerTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.registerTime)
      .optionallyWith(
        deregisterTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.deregisterTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.InstanceInfo.ReadOnly =
    zio.aws.codedeploy.model.InstanceInfo.wrap(buildAwsValue())
}
object InstanceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.InstanceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.InstanceInfo =
      zio.aws.codedeploy.model.InstanceInfo(
        instanceName.map(value => value),
        iamSessionArn.map(value => value),
        iamUserArn.map(value => value),
        instanceArn.map(value => value),
        registerTime.map(value => value),
        deregisterTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def instanceName: Option[InstanceName]
    def iamSessionArn: Option[IamSessionArn]
    def iamUserArn: Option[IamUserArn]
    def instanceArn: Option[InstanceArn]
    def registerTime: Option[Timestamp]
    def deregisterTime: Option[Timestamp]
    def tags: Option[List[zio.aws.codedeploy.model.Tag.ReadOnly]]
    def getInstanceName: ZIO[Any, AwsError, InstanceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getIamSessionArn: ZIO[Any, AwsError, IamSessionArn] =
      AwsError.unwrapOptionField("iamSessionArn", iamSessionArn)
    def getIamUserArn: ZIO[Any, AwsError, IamUserArn] =
      AwsError.unwrapOptionField("iamUserArn", iamUserArn)
    def getInstanceArn: ZIO[Any, AwsError, InstanceArn] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getRegisterTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registerTime", registerTime)
    def getDeregisterTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deregisterTime", deregisterTime)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.InstanceInfo
  ) extends zio.aws.codedeploy.model.InstanceInfo.ReadOnly {
    override val instanceName: Option[InstanceName] = scala
      .Option(impl.instanceName())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceName(value))
    override val iamSessionArn: Option[IamSessionArn] = scala
      .Option(impl.iamSessionArn())
      .map(value => zio.aws.codedeploy.model.primitives.IamSessionArn(value))
    override val iamUserArn: Option[IamUserArn] = scala
      .Option(impl.iamUserArn())
      .map(value => zio.aws.codedeploy.model.primitives.IamUserArn(value))
    override val instanceArn: Option[InstanceArn] = scala
      .Option(impl.instanceArn())
      .map(value => zio.aws.codedeploy.model.primitives.InstanceArn(value))
    override val registerTime: Option[Timestamp] = scala
      .Option(impl.registerTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val deregisterTime: Option[Timestamp] = scala
      .Option(impl.deregisterTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val tags: Option[List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codedeploy.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.InstanceInfo
  ): zio.aws.codedeploy.model.InstanceInfo.ReadOnly = new Wrapper(impl)
}
