package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.AutoScalingGroupName
import scala.jdk.CollectionConverters._
final case class TargetInstances(
    tagFilters: Option[Iterable[zio.aws.codedeploy.model.EC2TagFilter]] = None,
    autoScalingGroups: Option[Iterable[AutoScalingGroupName]] = None,
    ec2TagSet: Option[zio.aws.codedeploy.model.EC2TagSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TargetInstances = {
    import TargetInstances.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TargetInstances
      .builder()
      .optionallyWith(
        tagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagFilters)
      .optionallyWith(
        autoScalingGroups.map(value =>
          value.map { item =>
            AutoScalingGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.autoScalingGroups)
      .optionallyWith(ec2TagSet.map(value => value.buildAwsValue()))(
        _.ec2TagSet
      )
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TargetInstances.ReadOnly =
    zio.aws.codedeploy.model.TargetInstances.wrap(buildAwsValue())
}
object TargetInstances {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TargetInstances
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TargetInstances =
      zio.aws.codedeploy.model.TargetInstances(
        tagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        autoScalingGroups.map(value => value),
        ec2TagSet.map(value => value.asEditable)
      )
    def tagFilters: Option[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]]
    def autoScalingGroups: Option[List[AutoScalingGroupName]]
    def ec2TagSet: Option[zio.aws.codedeploy.model.EC2TagSet.ReadOnly]
    def getTagFilters: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.EC2TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("tagFilters", tagFilters)
    def getAutoScalingGroups: ZIO[Any, AwsError, List[AutoScalingGroupName]] =
      AwsError.unwrapOptionField("autoScalingGroups", autoScalingGroups)
    def getEc2TagSet
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.EC2TagSet.ReadOnly] =
      AwsError.unwrapOptionField("ec2TagSet", ec2TagSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetInstances
  ) extends zio.aws.codedeploy.model.TargetInstances.ReadOnly {
    override val tagFilters
        : Option[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]] = scala
      .Option(impl.tagFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.EC2TagFilter.wrap(item)
        }.toList
      )
    override val autoScalingGroups: Option[List[AutoScalingGroupName]] = scala
      .Option(impl.autoScalingGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.primitives.AutoScalingGroupName(item)
        }.toList
      )
    override val ec2TagSet
        : Option[zio.aws.codedeploy.model.EC2TagSet.ReadOnly] = scala
      .Option(impl.ec2TagSet())
      .map(value => zio.aws.codedeploy.model.EC2TagSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TargetInstances
  ): zio.aws.codedeploy.model.TargetInstances.ReadOnly = new Wrapper(impl)
}
