package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{Timestamp, DeploymentId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LastDeploymentInfo(
    deploymentId: Option[DeploymentId] = None,
    status: Option[zio.aws.codedeploy.model.DeploymentStatus] = None,
    endTime: Option[Timestamp] = None,
    createTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo = {
    import LastDeploymentInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        createTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTime)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly =
    zio.aws.codedeploy.model.LastDeploymentInfo.wrap(buildAwsValue())
}
object LastDeploymentInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.LastDeploymentInfo =
      zio.aws.codedeploy.model.LastDeploymentInfo(
        deploymentId.map(value => value),
        status.map(value => value),
        endTime.map(value => value),
        createTime.map(value => value)
      )
    def deploymentId: Option[DeploymentId]
    def status: Option[zio.aws.codedeploy.model.DeploymentStatus]
    def endTime: Option[Timestamp]
    def createTime: Option[Timestamp]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.DeploymentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCreateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo
  ) extends zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly {
    override val deploymentId: Option[DeploymentId] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val status: Option[zio.aws.codedeploy.model.DeploymentStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.codedeploy.model.DeploymentStatus.wrap(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
    override val createTime: Option[Timestamp] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.codedeploy.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.LastDeploymentInfo
  ): zio.aws.codedeploy.model.LastDeploymentInfo.ReadOnly = new Wrapper(impl)
}
