package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.{Key, Arn}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: Arn,
    tagKeys: Iterable[Key]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        Key.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.UntagResourceRequest.ReadOnly =
    zio.aws.codedeploy.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.UntagResourceRequest =
      zio.aws.codedeploy.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: Arn
    def tagKeys: List[Key]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[Key]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest
  ) extends zio.aws.codedeploy.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.codedeploy.model.primitives.Arn(impl.resourceArn())
    override val tagKeys: List[Key] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.primitives.Key(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.UntagResourceRequest
  ): zio.aws.codedeploy.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
