package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait LifecycleErrorCode {
  def unwrap
      : software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode
}
object LifecycleErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode
  ): zio.aws.codedeploy.model.LifecycleErrorCode = value match {
    case software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SCRIPT_MISSING =>
      val r = ScriptMissing
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SCRIPT_NOT_EXECUTABLE =>
      val r = ScriptNotExecutable
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SCRIPT_TIMED_OUT =>
      val r = ScriptTimedOut
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SCRIPT_FAILED =>
      val r = ScriptFailed
      r
    case software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.UNKNOWN_ERROR =>
      val r = UnknownError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codedeploy.model.LifecycleErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode =
      software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object Success extends zio.aws.codedeploy.model.LifecycleErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode =
      software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SUCCESS
  }
  case object ScriptMissing
      extends zio.aws.codedeploy.model.LifecycleErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode =
      software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SCRIPT_MISSING
  }
  case object ScriptNotExecutable
      extends zio.aws.codedeploy.model.LifecycleErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode =
      software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SCRIPT_NOT_EXECUTABLE
  }
  case object ScriptTimedOut
      extends zio.aws.codedeploy.model.LifecycleErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode =
      software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SCRIPT_TIMED_OUT
  }
  case object ScriptFailed extends zio.aws.codedeploy.model.LifecycleErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode =
      software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.SCRIPT_FAILED
  }
  case object UnknownError extends zio.aws.codedeploy.model.LifecycleErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode =
      software.amazon.awssdk.services.codedeploy.model.LifecycleErrorCode.UNKNOWN_ERROR
  }
}
