package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  TrafficWeight,
  ECSTaskSetStatus,
  ECSTaskSetCount,
  ECSTaskSetIdentifier
}
import scala.jdk.CollectionConverters._
final case class ECSTaskSet(
    identifer: Option[ECSTaskSetIdentifier] = None,
    desiredCount: Option[ECSTaskSetCount] = None,
    pendingCount: Option[ECSTaskSetCount] = None,
    runningCount: Option[ECSTaskSetCount] = None,
    status: Option[ECSTaskSetStatus] = None,
    trafficWeight: Option[TrafficWeight] = None,
    targetGroup: Option[zio.aws.codedeploy.model.TargetGroupInfo] = None,
    taskSetLabel: Option[zio.aws.codedeploy.model.TargetLabel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ECSTaskSet = {
    import ECSTaskSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ECSTaskSet
      .builder()
      .optionallyWith(
        identifer.map(value =>
          ECSTaskSetIdentifier.unwrap(value): java.lang.String
        )
      )(_.identifer)
      .optionallyWith(
        desiredCount.map(value => ECSTaskSetCount.unwrap(value): java.lang.Long)
      )(_.desiredCount)
      .optionallyWith(
        pendingCount.map(value => ECSTaskSetCount.unwrap(value): java.lang.Long)
      )(_.pendingCount)
      .optionallyWith(
        runningCount.map(value => ECSTaskSetCount.unwrap(value): java.lang.Long)
      )(_.runningCount)
      .optionallyWith(
        status.map(value => ECSTaskSetStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        trafficWeight.map(value =>
          TrafficWeight.unwrap(value): java.lang.Double
        )
      )(_.trafficWeight)
      .optionallyWith(targetGroup.map(value => value.buildAwsValue()))(
        _.targetGroup
      )
      .optionallyWith(taskSetLabel.map(value => value.unwrap))(_.taskSetLabel)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.ECSTaskSet.ReadOnly =
    zio.aws.codedeploy.model.ECSTaskSet.wrap(buildAwsValue())
}
object ECSTaskSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ECSTaskSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ECSTaskSet =
      zio.aws.codedeploy.model.ECSTaskSet(
        identifer.map(value => value),
        desiredCount.map(value => value),
        pendingCount.map(value => value),
        runningCount.map(value => value),
        status.map(value => value),
        trafficWeight.map(value => value),
        targetGroup.map(value => value.asEditable),
        taskSetLabel.map(value => value)
      )
    def identifer: Option[ECSTaskSetIdentifier]
    def desiredCount: Option[ECSTaskSetCount]
    def pendingCount: Option[ECSTaskSetCount]
    def runningCount: Option[ECSTaskSetCount]
    def status: Option[ECSTaskSetStatus]
    def trafficWeight: Option[TrafficWeight]
    def targetGroup: Option[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly]
    def taskSetLabel: Option[zio.aws.codedeploy.model.TargetLabel]
    def getIdentifer: ZIO[Any, AwsError, ECSTaskSetIdentifier] =
      AwsError.unwrapOptionField("identifer", identifer)
    def getDesiredCount: ZIO[Any, AwsError, ECSTaskSetCount] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getPendingCount: ZIO[Any, AwsError, ECSTaskSetCount] =
      AwsError.unwrapOptionField("pendingCount", pendingCount)
    def getRunningCount: ZIO[Any, AwsError, ECSTaskSetCount] =
      AwsError.unwrapOptionField("runningCount", runningCount)
    def getStatus: ZIO[Any, AwsError, ECSTaskSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTrafficWeight: ZIO[Any, AwsError, TrafficWeight] =
      AwsError.unwrapOptionField("trafficWeight", trafficWeight)
    def getTargetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly
    ] = AwsError.unwrapOptionField("targetGroup", targetGroup)
    def getTaskSetLabel
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TargetLabel] =
      AwsError.unwrapOptionField("taskSetLabel", taskSetLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ECSTaskSet
  ) extends zio.aws.codedeploy.model.ECSTaskSet.ReadOnly {
    override val identifer: Option[ECSTaskSetIdentifier] = scala
      .Option(impl.identifer())
      .map(value =>
        zio.aws.codedeploy.model.primitives.ECSTaskSetIdentifier(value)
      )
    override val desiredCount: Option[ECSTaskSetCount] = scala
      .Option(impl.desiredCount())
      .map(value => zio.aws.codedeploy.model.primitives.ECSTaskSetCount(value))
    override val pendingCount: Option[ECSTaskSetCount] = scala
      .Option(impl.pendingCount())
      .map(value => zio.aws.codedeploy.model.primitives.ECSTaskSetCount(value))
    override val runningCount: Option[ECSTaskSetCount] = scala
      .Option(impl.runningCount())
      .map(value => zio.aws.codedeploy.model.primitives.ECSTaskSetCount(value))
    override val status: Option[ECSTaskSetStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.codedeploy.model.primitives.ECSTaskSetStatus(value))
    override val trafficWeight: Option[TrafficWeight] = scala
      .Option(impl.trafficWeight())
      .map(value => zio.aws.codedeploy.model.primitives.TrafficWeight(value))
    override val targetGroup
        : Option[zio.aws.codedeploy.model.TargetGroupInfo.ReadOnly] = scala
      .Option(impl.targetGroup())
      .map(value => zio.aws.codedeploy.model.TargetGroupInfo.wrap(value))
    override val taskSetLabel: Option[zio.aws.codedeploy.model.TargetLabel] =
      scala
        .Option(impl.taskSetLabel())
        .map(value => zio.aws.codedeploy.model.TargetLabel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ECSTaskSet
  ): zio.aws.codedeploy.model.ECSTaskSet.ReadOnly = new Wrapper(impl)
}
