package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codedeploy.model.primitives.InstanceName
import scala.jdk.CollectionConverters._
final case class AddTagsToOnPremisesInstancesRequest(
    tags: Iterable[zio.aws.codedeploy.model.Tag],
    instanceNames: Iterable[InstanceName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest = {
    import AddTagsToOnPremisesInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .instanceNames(instanceNames.map { item =>
        InstanceName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.AddTagsToOnPremisesInstancesRequest.ReadOnly =
    zio.aws.codedeploy.model.AddTagsToOnPremisesInstancesRequest
      .wrap(buildAwsValue())
}
object AddTagsToOnPremisesInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.AddTagsToOnPremisesInstancesRequest =
      zio.aws.codedeploy.model.AddTagsToOnPremisesInstancesRequest(
        tags.map { item =>
          item.asEditable
        },
        instanceNames
      )
    def tags: List[zio.aws.codedeploy.model.Tag.ReadOnly]
    def instanceNames: List[InstanceName]
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.codedeploy.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
    def getInstanceNames: ZIO[Any, Nothing, List[InstanceName]] =
      ZIO.succeed(instanceNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest
  ) extends zio.aws.codedeploy.model.AddTagsToOnPremisesInstancesRequest.ReadOnly {
    override val tags: List[zio.aws.codedeploy.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.Tag.wrap(item)
      }
      .toList
    override val instanceNames: List[InstanceName] = impl
      .instanceNames()
      .asScala
      .map { item =>
        zio.aws.codedeploy.model.primitives.InstanceName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.AddTagsToOnPremisesInstancesRequest
  ): zio.aws.codedeploy.model.AddTagsToOnPremisesInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
