package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.AlarmName
import scala.jdk.CollectionConverters._
final case class Alarm(name: Option[AlarmName] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.Alarm = {
    import Alarm.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.Alarm
      .builder()
      .optionallyWith(
        name.map(value => AlarmName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.Alarm.ReadOnly =
    zio.aws.codedeploy.model.Alarm.wrap(buildAwsValue())
}
object Alarm {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codedeploy.model.Alarm] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.Alarm =
      zio.aws.codedeploy.model.Alarm(name.map(value => value))
    def name: Option[AlarmName]
    def getName: ZIO[Any, AwsError, AlarmName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.Alarm
  ) extends zio.aws.codedeploy.model.Alarm.ReadOnly {
    override val name: Option[AlarmName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codedeploy.model.primitives.AlarmName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.Alarm
  ): zio.aws.codedeploy.model.Alarm.ReadOnly = new Wrapper(impl)
}
