package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  Time,
  TargetArn,
  TargetId,
  DeploymentId
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InstanceTarget(
    deploymentId: Option[DeploymentId] = None,
    targetId: Option[TargetId] = None,
    targetArn: Option[TargetArn] = None,
    status: Option[zio.aws.codedeploy.model.TargetStatus] = None,
    lastUpdatedAt: Option[Time] = None,
    lifecycleEvents: Option[Iterable[zio.aws.codedeploy.model.LifecycleEvent]] =
      None,
    instanceLabel: Option[zio.aws.codedeploy.model.TargetLabel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.InstanceTarget = {
    import InstanceTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.InstanceTarget
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(
        targetArn.map(value => TargetArn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(lastUpdatedAt.map(value => Time.unwrap(value): Instant))(
        _.lastUpdatedAt
      )
      .optionallyWith(
        lifecycleEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lifecycleEvents)
      .optionallyWith(instanceLabel.map(value => value.unwrap))(_.instanceLabel)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.InstanceTarget.ReadOnly =
    zio.aws.codedeploy.model.InstanceTarget.wrap(buildAwsValue())
}
object InstanceTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.InstanceTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.InstanceTarget =
      zio.aws.codedeploy.model.InstanceTarget(
        deploymentId.map(value => value),
        targetId.map(value => value),
        targetArn.map(value => value),
        status.map(value => value),
        lastUpdatedAt.map(value => value),
        lifecycleEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceLabel.map(value => value)
      )
    def deploymentId: Option[DeploymentId]
    def targetId: Option[TargetId]
    def targetArn: Option[TargetArn]
    def status: Option[zio.aws.codedeploy.model.TargetStatus]
    def lastUpdatedAt: Option[Time]
    def lifecycleEvents
        : Option[List[zio.aws.codedeploy.model.LifecycleEvent.ReadOnly]]
    def instanceLabel: Option[zio.aws.codedeploy.model.TargetLabel]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getTargetArn: ZIO[Any, AwsError, TargetArn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.codedeploy.model.TargetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastUpdatedAt: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getLifecycleEvents: ZIO[Any, AwsError, List[
      zio.aws.codedeploy.model.LifecycleEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("lifecycleEvents", lifecycleEvents)
    def getInstanceLabel
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.TargetLabel] =
      AwsError.unwrapOptionField("instanceLabel", instanceLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.InstanceTarget
  ) extends zio.aws.codedeploy.model.InstanceTarget.ReadOnly {
    override val deploymentId: Option[DeploymentId] = scala
      .Option(impl.deploymentId())
      .map(value => zio.aws.codedeploy.model.primitives.DeploymentId(value))
    override val targetId: Option[TargetId] = scala
      .Option(impl.targetId())
      .map(value => zio.aws.codedeploy.model.primitives.TargetId(value))
    override val targetArn: Option[TargetArn] = scala
      .Option(impl.targetArn())
      .map(value => zio.aws.codedeploy.model.primitives.TargetArn(value))
    override val status: Option[zio.aws.codedeploy.model.TargetStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.codedeploy.model.TargetStatus.wrap(value))
    override val lastUpdatedAt: Option[Time] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.codedeploy.model.primitives.Time(value))
    override val lifecycleEvents
        : Option[List[zio.aws.codedeploy.model.LifecycleEvent.ReadOnly]] = scala
      .Option(impl.lifecycleEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.LifecycleEvent.wrap(item)
        }.toList
      )
    override val instanceLabel: Option[zio.aws.codedeploy.model.TargetLabel] =
      scala
        .Option(impl.instanceLabel())
        .map(value => zio.aws.codedeploy.model.TargetLabel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.InstanceTarget
  ): zio.aws.codedeploy.model.InstanceTarget.ReadOnly = new Wrapper(impl)
}
