package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.ExternalId
import scala.jdk.CollectionConverters._
final case class DeleteResourcesByExternalIdRequest(
    externalId: Option[ExternalId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest = {
    import DeleteResourcesByExternalIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest
      .builder()
      .optionallyWith(
        externalId.map(value => ExternalId.unwrap(value): java.lang.String)
      )(_.externalId)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.DeleteResourcesByExternalIdRequest.ReadOnly =
    zio.aws.codedeploy.model.DeleteResourcesByExternalIdRequest
      .wrap(buildAwsValue())
}
object DeleteResourcesByExternalIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codedeploy.model.DeleteResourcesByExternalIdRequest =
      zio.aws.codedeploy.model
        .DeleteResourcesByExternalIdRequest(externalId.map(value => value))
    def externalId: Option[ExternalId]
    def getExternalId: ZIO[Any, AwsError, ExternalId] =
      AwsError.unwrapOptionField("externalId", externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest
  ) extends zio.aws.codedeploy.model.DeleteResourcesByExternalIdRequest.ReadOnly {
    override val externalId: Option[ExternalId] = scala
      .Option(impl.externalId())
      .map(value => zio.aws.codedeploy.model.primitives.ExternalId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.DeleteResourcesByExternalIdRequest
  ): zio.aws.codedeploy.model.DeleteResourcesByExternalIdRequest.ReadOnly =
    new Wrapper(impl)
}
