package zio.aws.codedeploy.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{WaitTimeInMins, Percentage}
import scala.jdk.CollectionConverters._
final case class TimeBasedCanary(
    canaryPercentage: Option[Percentage] = None,
    canaryInterval: Option[WaitTimeInMins] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary = {
    import TimeBasedCanary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary
      .builder()
      .optionallyWith(
        canaryPercentage.map(value => Percentage.unwrap(value): Integer)
      )(_.canaryPercentage)
      .optionallyWith(
        canaryInterval.map(value => WaitTimeInMins.unwrap(value): Integer)
      )(_.canaryInterval)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly =
    zio.aws.codedeploy.model.TimeBasedCanary.wrap(buildAwsValue())
}
object TimeBasedCanary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TimeBasedCanary =
      zio.aws.codedeploy.model.TimeBasedCanary(
        canaryPercentage.map(value => value),
        canaryInterval.map(value => value)
      )
    def canaryPercentage: Option[Percentage]
    def canaryInterval: Option[WaitTimeInMins]
    def getCanaryPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("canaryPercentage", canaryPercentage)
    def getCanaryInterval: ZIO[Any, AwsError, WaitTimeInMins] =
      AwsError.unwrapOptionField("canaryInterval", canaryInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary
  ) extends zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly {
    override val canaryPercentage: Option[Percentage] = scala
      .Option(impl.canaryPercentage())
      .map(value => zio.aws.codedeploy.model.primitives.Percentage(value))
    override val canaryInterval: Option[WaitTimeInMins] = scala
      .Option(impl.canaryInterval())
      .map(value => zio.aws.codedeploy.model.primitives.WaitTimeInMins(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TimeBasedCanary
  ): zio.aws.codedeploy.model.TimeBasedCanary.ReadOnly = new Wrapper(impl)
}
