package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{NextToken, ApplicationName}
import scala.jdk.CollectionConverters._
final case class ListDeploymentGroupsRequest(
    applicationName: ApplicationName,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest = {
    import ListDeploymentGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListDeploymentGroupsRequest.ReadOnly =
    zio.aws.codedeploy.model.ListDeploymentGroupsRequest.wrap(buildAwsValue())
}
object ListDeploymentGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListDeploymentGroupsRequest =
      zio.aws.codedeploy.model.ListDeploymentGroupsRequest(
        applicationName,
        nextToken.map(value => value)
      )
    def applicationName: ApplicationName
    def nextToken: Option[NextToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest
  ) extends zio.aws.codedeploy.model.ListDeploymentGroupsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListDeploymentGroupsRequest
  ): zio.aws.codedeploy.model.ListDeploymentGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
