package zio.aws.codedeploy
import zio.prelude.Subtype
import zio.aws.codedeploy.model.primitives.{
  Key,
  ErrorMessage,
  DeploymentGroupName,
  DeploymentConfigName,
  ApplicationName,
  ListenerArn,
  DeploymentId,
  InstanceName,
  AutoScalingGroupName,
  TargetId,
  FilterValue,
  GitHubAccountTokenName
}
import java.time.Instant
import zio.aws.codedeploy.model.primitives.ScriptName.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AdditionalDeploymentStatusInfo extends Subtype[String]
    type AdditionalDeploymentStatusInfo =
      zio.aws.codedeploy.model.primitives.AdditionalDeploymentStatusInfo.Type
    object AlarmName extends Subtype[String]
    type AlarmName = zio.aws.codedeploy.model.primitives.AlarmName.Type
    object ApplicationId extends Subtype[String]
    type ApplicationId = zio.aws.codedeploy.model.primitives.ApplicationId.Type
    object ApplicationName extends Subtype[String]
    type ApplicationName =
      zio.aws.codedeploy.model.primitives.ApplicationName.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.codedeploy.model.primitives.Arn.Type
    object AutoScalingGroupHook extends Subtype[String]
    type AutoScalingGroupHook =
      zio.aws.codedeploy.model.primitives.AutoScalingGroupHook.Type
    object AutoScalingGroupName extends Subtype[String]
    type AutoScalingGroupName =
      zio.aws.codedeploy.model.primitives.AutoScalingGroupName.Type
    object CloudFormationResourceType extends Subtype[String]
    type CloudFormationResourceType =
      zio.aws.codedeploy.model.primitives.CloudFormationResourceType.Type
    object CommitId extends Subtype[String]
    type CommitId = zio.aws.codedeploy.model.primitives.CommitId.Type
    object DeploymentConfigId extends Subtype[String]
    type DeploymentConfigId =
      zio.aws.codedeploy.model.primitives.DeploymentConfigId.Type
    object DeploymentConfigName extends Subtype[String]
    type DeploymentConfigName =
      zio.aws.codedeploy.model.primitives.DeploymentConfigName.Type
    object DeploymentGroupId extends Subtype[String]
    type DeploymentGroupId =
      zio.aws.codedeploy.model.primitives.DeploymentGroupId.Type
    object DeploymentGroupName extends Subtype[String]
    type DeploymentGroupName =
      zio.aws.codedeploy.model.primitives.DeploymentGroupName.Type
    object DeploymentId extends Subtype[String]
    type DeploymentId = zio.aws.codedeploy.model.primitives.DeploymentId.Type
    object Description extends Subtype[String]
    type Description = zio.aws.codedeploy.model.primitives.Description.Type
    object Duration extends Subtype[Int]
    type Duration = zio.aws.codedeploy.model.primitives.Duration.Type
    object ECSClusterName extends Subtype[String]
    type ECSClusterName =
      zio.aws.codedeploy.model.primitives.ECSClusterName.Type
    object ECSServiceName extends Subtype[String]
    type ECSServiceName =
      zio.aws.codedeploy.model.primitives.ECSServiceName.Type
    object ECSTaskSetCount extends Subtype[Long]
    type ECSTaskSetCount =
      zio.aws.codedeploy.model.primitives.ECSTaskSetCount.Type
    object ECSTaskSetIdentifier extends Subtype[String]
    type ECSTaskSetIdentifier =
      zio.aws.codedeploy.model.primitives.ECSTaskSetIdentifier.Type
    object ECSTaskSetStatus extends Subtype[String]
    type ECSTaskSetStatus =
      zio.aws.codedeploy.model.primitives.ECSTaskSetStatus.Type
    object ELBName extends Subtype[String]
    type ELBName = zio.aws.codedeploy.model.primitives.ELBName.Type
    object ETag extends Subtype[String]
    type ETag = zio.aws.codedeploy.model.primitives.ETag.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.codedeploy.model.primitives.ErrorMessage.Type
    object ExternalId extends Subtype[String]
    type ExternalId = zio.aws.codedeploy.model.primitives.ExternalId.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.codedeploy.model.primitives.FilterValue.Type
    object GitHubAccountTokenName extends Subtype[String]
    type GitHubAccountTokenName =
      zio.aws.codedeploy.model.primitives.GitHubAccountTokenName.Type
    object IamSessionArn extends Subtype[String]
    type IamSessionArn = zio.aws.codedeploy.model.primitives.IamSessionArn.Type
    object IamUserArn extends Subtype[String]
    type IamUserArn = zio.aws.codedeploy.model.primitives.IamUserArn.Type
    object InstanceArn extends Subtype[String]
    type InstanceArn = zio.aws.codedeploy.model.primitives.InstanceArn.Type
    object InstanceCount extends Subtype[Long]
    type InstanceCount = zio.aws.codedeploy.model.primitives.InstanceCount.Type
    object InstanceId extends Subtype[String]
    type InstanceId = zio.aws.codedeploy.model.primitives.InstanceId.Type
    object InstanceName extends Subtype[String]
    type InstanceName = zio.aws.codedeploy.model.primitives.InstanceName.Type
    object Key extends Subtype[String]
    type Key = zio.aws.codedeploy.model.primitives.Key.Type
    object LambdaFunctionAlias extends Subtype[String]
    type LambdaFunctionAlias =
      zio.aws.codedeploy.model.primitives.LambdaFunctionAlias.Type
    object LambdaFunctionName extends Subtype[String]
    type LambdaFunctionName =
      zio.aws.codedeploy.model.primitives.LambdaFunctionName.Type
    object LifecycleEventHookExecutionId extends Subtype[String]
    type LifecycleEventHookExecutionId =
      zio.aws.codedeploy.model.primitives.LifecycleEventHookExecutionId.Type
    object LifecycleEventName extends Subtype[String]
    type LifecycleEventName =
      zio.aws.codedeploy.model.primitives.LifecycleEventName.Type
    object LifecycleMessage extends Subtype[String]
    type LifecycleMessage =
      zio.aws.codedeploy.model.primitives.LifecycleMessage.Type
    object ListenerArn extends Subtype[String]
    type ListenerArn = zio.aws.codedeploy.model.primitives.ListenerArn.Type
    object LogTail extends Subtype[String]
    type LogTail = zio.aws.codedeploy.model.primitives.LogTail.Type
    object Message extends Subtype[String]
    type Message = zio.aws.codedeploy.model.primitives.Message.Type
    object MinimumHealthyHostsValue extends Subtype[Int]
    type MinimumHealthyHostsValue =
      zio.aws.codedeploy.model.primitives.MinimumHealthyHostsValue.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.codedeploy.model.primitives.NextToken.Type
    object NullableBoolean extends Subtype[Boolean]
    type NullableBoolean =
      zio.aws.codedeploy.model.primitives.NullableBoolean.Type
    object Percentage extends Subtype[Int]
    type Percentage = zio.aws.codedeploy.model.primitives.Percentage.Type
    object RawStringContent extends Subtype[String]
    type RawStringContent =
      zio.aws.codedeploy.model.primitives.RawStringContent.Type
    object RawStringSha256 extends Subtype[String]
    type RawStringSha256 =
      zio.aws.codedeploy.model.primitives.RawStringSha256.Type
    object Repository extends Subtype[String]
    type Repository = zio.aws.codedeploy.model.primitives.Repository.Type
    object Role extends Subtype[String]
    type Role = zio.aws.codedeploy.model.primitives.Role.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.codedeploy.model.primitives.S3Bucket.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.codedeploy.model.primitives.S3Key.Type
    object ScriptName extends Subtype[String]
    type ScriptName = zio.aws.codedeploy.model.primitives.ScriptName.Type
    object TargetArn extends Subtype[String]
    type TargetArn = zio.aws.codedeploy.model.primitives.TargetArn.Type
    object TargetGroupName extends Subtype[String]
    type TargetGroupName =
      zio.aws.codedeploy.model.primitives.TargetGroupName.Type
    object TargetId extends Subtype[String]
    type TargetId = zio.aws.codedeploy.model.primitives.TargetId.Type
    object Time extends Subtype[Instant]
    type Time = zio.aws.codedeploy.model.primitives.Time.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.codedeploy.model.primitives.Timestamp.Type
    object TrafficWeight extends Subtype[Double]
    type TrafficWeight = zio.aws.codedeploy.model.primitives.TrafficWeight.Type
    object TriggerName extends Subtype[String]
    type TriggerName = zio.aws.codedeploy.model.primitives.TriggerName.Type
    object TriggerTargetArn extends Subtype[String]
    type TriggerTargetArn =
      zio.aws.codedeploy.model.primitives.TriggerTargetArn.Type
    object Value extends Subtype[String]
    type Value = zio.aws.codedeploy.model.primitives.Value.Type
    object Version extends Subtype[String]
    type Version = zio.aws.codedeploy.model.primitives.Version.Type
    object VersionId extends Subtype[String]
    type VersionId = zio.aws.codedeploy.model.primitives.VersionId.Type
    object WaitTimeInMins extends Subtype[Int]
    type WaitTimeInMins =
      zio.aws.codedeploy.model.primitives.WaitTimeInMins.Type
  }
  type AlarmList = List[zio.aws.codedeploy.model.Alarm]
  type ApplicationsInfoList = List[zio.aws.codedeploy.model.ApplicationInfo]
  type ApplicationsList = List[ApplicationName]
  type AutoRollbackEventsList = List[zio.aws.codedeploy.model.AutoRollbackEvent]
  type AutoScalingGroupList = List[zio.aws.codedeploy.model.AutoScalingGroup]
  type AutoScalingGroupNameList = List[AutoScalingGroupName]
  type DeploymentConfigsList = List[DeploymentConfigName]
  type DeploymentGroupInfoList =
    List[zio.aws.codedeploy.model.DeploymentGroupInfo]
  type DeploymentGroupsList = List[DeploymentGroupName]
  type DeploymentStatusList = List[zio.aws.codedeploy.model.DeploymentStatus]
  type DeploymentStatusMessageList = List[ErrorMessage]
  type DeploymentTargetList = List[zio.aws.codedeploy.model.DeploymentTarget]
  type DeploymentsInfoList = List[zio.aws.codedeploy.model.DeploymentInfo]
  type DeploymentsList = List[DeploymentId]
  type EC2TagFilterList = List[zio.aws.codedeploy.model.EC2TagFilter]
  type EC2TagSetList = List[Iterable[zio.aws.codedeploy.model.EC2TagFilter]]
  type ECSServiceList = List[zio.aws.codedeploy.model.ECSService]
  type ECSTaskSetList = List[zio.aws.codedeploy.model.ECSTaskSet]
  type ELBInfoList = List[zio.aws.codedeploy.model.ELBInfo]
  type FilterValueList = List[FilterValue]
  type GitHubAccountTokenNameList = List[GitHubAccountTokenName]
  type InstanceInfoList = List[zio.aws.codedeploy.model.InstanceInfo]
  type InstanceNameList = List[InstanceName]
  type LifecycleEventList = List[zio.aws.codedeploy.model.LifecycleEvent]
  type ListenerArnList = List[ListenerArn]
  type OnPremisesTagSetList = List[Iterable[zio.aws.codedeploy.model.TagFilter]]
  type RevisionInfoList = List[zio.aws.codedeploy.model.RevisionInfo]
  type RevisionLocationList = List[zio.aws.codedeploy.model.RevisionLocation]
  type TagFilterList = List[zio.aws.codedeploy.model.TagFilter]
  type TagKeyList = List[Key]
  type TagList = List[zio.aws.codedeploy.model.Tag]
  type TargetFilters =
    Map[zio.aws.codedeploy.model.TargetFilterName, Iterable[FilterValue]]
  type TargetGroupInfoList = List[zio.aws.codedeploy.model.TargetGroupInfo]
  type TargetGroupPairInfoList =
    List[zio.aws.codedeploy.model.TargetGroupPairInfo]
  type TargetIdList = List[TargetId]
  type TriggerConfigList = List[zio.aws.codedeploy.model.TriggerConfig]
  type TriggerEventTypeList = List[zio.aws.codedeploy.model.TriggerEventType]
}
