package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EC2TagSet(
    ec2TagSetList: Option[
      Iterable[Iterable[zio.aws.codedeploy.model.EC2TagFilter]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.EC2TagSet = {
    import EC2TagSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.EC2TagSet
      .builder()
      .optionallyWith(
        ec2TagSetList.map(value =>
          value.map { item =>
            item.map { item =>
              item.buildAwsValue()
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.ec2TagSetList)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.EC2TagSet.ReadOnly =
    zio.aws.codedeploy.model.EC2TagSet.wrap(buildAwsValue())
}
object EC2TagSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.EC2TagSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.EC2TagSet =
      zio.aws.codedeploy.model.EC2TagSet(
        ec2TagSetList.map(value =>
          value.map { item =>
            item.map { item =>
              item.asEditable
            }
          }
        )
      )
    def ec2TagSetList
        : Option[List[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]]]
    def getEc2TagSetList: ZIO[Any, AwsError, List[
      List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]
    ]] = AwsError.unwrapOptionField("ec2TagSetList", ec2TagSetList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.EC2TagSet
  ) extends zio.aws.codedeploy.model.EC2TagSet.ReadOnly {
    override val ec2TagSetList
        : Option[List[List[zio.aws.codedeploy.model.EC2TagFilter.ReadOnly]]] =
      scala
        .Option(impl.ec2TagSetList())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              zio.aws.codedeploy.model.EC2TagFilter.wrap(item)
            }.toList
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.EC2TagSet
  ): zio.aws.codedeploy.model.EC2TagSet.ReadOnly = new Wrapper(impl)
}
