package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AutoRollbackConfiguration(
    enabled: Option[Boolean] = None,
    events: Option[Iterable[zio.aws.codedeploy.model.AutoRollbackEvent]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration = {
    import AutoRollbackConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly =
    zio.aws.codedeploy.model.AutoRollbackConfiguration.wrap(buildAwsValue())
}
object AutoRollbackConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.AutoRollbackConfiguration =
      zio.aws.codedeploy.model.AutoRollbackConfiguration(
        enabled.map(value => value),
        events.map(value => value)
      )
    def enabled: Option[Boolean]
    def events: Option[List[zio.aws.codedeploy.model.AutoRollbackEvent]]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getEvents
        : ZIO[Any, AwsError, List[zio.aws.codedeploy.model.AutoRollbackEvent]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration
  ) extends zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val events
        : Option[List[zio.aws.codedeploy.model.AutoRollbackEvent]] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codedeploy.model.AutoRollbackEvent.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration
  ): zio.aws.codedeploy.model.AutoRollbackConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
