package zio.aws.codedeploy.model
import scala.jdk.CollectionConverters._
sealed trait SortOrder {
  def unwrap: software.amazon.awssdk.services.codedeploy.model.SortOrder
}
object SortOrder {
  def wrap(
      value: software.amazon.awssdk.services.codedeploy.model.SortOrder
  ): zio.aws.codedeploy.model.SortOrder = value match {
    case software.amazon.awssdk.services.codedeploy.model.SortOrder.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codedeploy.model.SortOrder.ASCENDING =>
      val r = ascending
      r
    case software.amazon.awssdk.services.codedeploy.model.SortOrder.DESCENDING =>
      val r = descending
      r
  }
  case object unknownToSdkVersion extends zio.aws.codedeploy.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.SortOrder =
      software.amazon.awssdk.services.codedeploy.model.SortOrder.UNKNOWN_TO_SDK_VERSION
  }
  case object ascending extends zio.aws.codedeploy.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.SortOrder =
      software.amazon.awssdk.services.codedeploy.model.SortOrder.ASCENDING
  }
  case object descending extends zio.aws.codedeploy.model.SortOrder {
    override def unwrap
        : software.amazon.awssdk.services.codedeploy.model.SortOrder =
      software.amazon.awssdk.services.codedeploy.model.SortOrder.DESCENDING
  }
}
