package zio.aws.codedeploy.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{WaitTimeInMins, Percentage}
import scala.jdk.CollectionConverters._
final case class TimeBasedLinear(
    linearPercentage: Option[Percentage] = None,
    linearInterval: Option[WaitTimeInMins] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.TimeBasedLinear = {
    import TimeBasedLinear.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.TimeBasedLinear
      .builder()
      .optionallyWith(
        linearPercentage.map(value => Percentage.unwrap(value): Integer)
      )(_.linearPercentage)
      .optionallyWith(
        linearInterval.map(value => WaitTimeInMins.unwrap(value): Integer)
      )(_.linearInterval)
      .build()
  }
  def asReadOnly: zio.aws.codedeploy.model.TimeBasedLinear.ReadOnly =
    zio.aws.codedeploy.model.TimeBasedLinear.wrap(buildAwsValue())
}
object TimeBasedLinear {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.TimeBasedLinear
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.TimeBasedLinear =
      zio.aws.codedeploy.model.TimeBasedLinear(
        linearPercentage.map(value => value),
        linearInterval.map(value => value)
      )
    def linearPercentage: Option[Percentage]
    def linearInterval: Option[WaitTimeInMins]
    def getLinearPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("linearPercentage", linearPercentage)
    def getLinearInterval: ZIO[Any, AwsError, WaitTimeInMins] =
      AwsError.unwrapOptionField("linearInterval", linearInterval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.TimeBasedLinear
  ) extends zio.aws.codedeploy.model.TimeBasedLinear.ReadOnly {
    override val linearPercentage: Option[Percentage] = scala
      .Option(impl.linearPercentage())
      .map(value => zio.aws.codedeploy.model.primitives.Percentage(value))
    override val linearInterval: Option[WaitTimeInMins] = scala
      .Option(impl.linearInterval())
      .map(value => zio.aws.codedeploy.model.primitives.WaitTimeInMins(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.TimeBasedLinear
  ): zio.aws.codedeploy.model.TimeBasedLinear.ReadOnly = new Wrapper(impl)
}
