package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  NextToken,
  S3Key,
  S3Bucket,
  ApplicationName
}
import scala.jdk.CollectionConverters._
final case class ListApplicationRevisionsRequest(
    applicationName: ApplicationName,
    sortBy: Option[zio.aws.codedeploy.model.ApplicationRevisionSortBy] = None,
    sortOrder: Option[zio.aws.codedeploy.model.SortOrder] = None,
    s3Bucket: Option[S3Bucket] = None,
    s3KeyPrefix: Option[S3Key] = None,
    deployed: Option[zio.aws.codedeploy.model.ListStateFilterAction] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest = {
    import ListApplicationRevisionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3KeyPrefix.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .optionallyWith(deployed.map(value => value.unwrap))(_.deployed)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.ListApplicationRevisionsRequest.ReadOnly =
    zio.aws.codedeploy.model.ListApplicationRevisionsRequest
      .wrap(buildAwsValue())
}
object ListApplicationRevisionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.ListApplicationRevisionsRequest =
      zio.aws.codedeploy.model.ListApplicationRevisionsRequest(
        applicationName,
        sortBy.map(value => value),
        sortOrder.map(value => value),
        s3Bucket.map(value => value),
        s3KeyPrefix.map(value => value),
        deployed.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: ApplicationName
    def sortBy: Option[zio.aws.codedeploy.model.ApplicationRevisionSortBy]
    def sortOrder: Option[zio.aws.codedeploy.model.SortOrder]
    def s3Bucket: Option[S3Bucket]
    def s3KeyPrefix: Option[S3Key]
    def deployed: Option[zio.aws.codedeploy.model.ListStateFilterAction]
    def nextToken: Option[NextToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.codedeploy.model.ApplicationRevisionSortBy
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.codedeploy.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3KeyPrefix: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getDeployed
        : ZIO[Any, AwsError, zio.aws.codedeploy.model.ListStateFilterAction] =
      AwsError.unwrapOptionField("deployed", deployed)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest
  ) extends zio.aws.codedeploy.model.ListApplicationRevisionsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.codedeploy.model.primitives
        .ApplicationName(impl.applicationName())
    override val sortBy
        : Option[zio.aws.codedeploy.model.ApplicationRevisionSortBy] = scala
      .Option(impl.sortBy())
      .map(value =>
        zio.aws.codedeploy.model.ApplicationRevisionSortBy.wrap(value)
      )
    override val sortOrder: Option[zio.aws.codedeploy.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.codedeploy.model.SortOrder.wrap(value))
    override val s3Bucket: Option[S3Bucket] = scala
      .Option(impl.s3Bucket())
      .map(value => zio.aws.codedeploy.model.primitives.S3Bucket(value))
    override val s3KeyPrefix: Option[S3Key] = scala
      .Option(impl.s3KeyPrefix())
      .map(value => zio.aws.codedeploy.model.primitives.S3Key(value))
    override val deployed
        : Option[zio.aws.codedeploy.model.ListStateFilterAction] = scala
      .Option(impl.deployed())
      .map(value => zio.aws.codedeploy.model.ListStateFilterAction.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codedeploy.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest
  ): zio.aws.codedeploy.model.ListApplicationRevisionsRequest.ReadOnly =
    new Wrapper(impl)
}
