package zio.aws.codedeploy.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codedeploy.model.primitives.{
  IamUserArn,
  IamSessionArn,
  InstanceName
}
import scala.jdk.CollectionConverters._
final case class RegisterOnPremisesInstanceRequest(
    instanceName: InstanceName,
    iamSessionArn: Option[IamSessionArn] = None,
    iamUserArn: Option[IamUserArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest = {
    import RegisterOnPremisesInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest
      .builder()
      .instanceName(InstanceName.unwrap(instanceName): java.lang.String)
      .optionallyWith(
        iamSessionArn.map(value =>
          IamSessionArn.unwrap(value): java.lang.String
        )
      )(_.iamSessionArn)
      .optionallyWith(
        iamUserArn.map(value => IamUserArn.unwrap(value): java.lang.String)
      )(_.iamUserArn)
      .build()
  }
  def asReadOnly
      : zio.aws.codedeploy.model.RegisterOnPremisesInstanceRequest.ReadOnly =
    zio.aws.codedeploy.model.RegisterOnPremisesInstanceRequest
      .wrap(buildAwsValue())
}
object RegisterOnPremisesInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codedeploy.model.RegisterOnPremisesInstanceRequest =
      zio.aws.codedeploy.model.RegisterOnPremisesInstanceRequest(
        instanceName,
        iamSessionArn.map(value => value),
        iamUserArn.map(value => value)
      )
    def instanceName: InstanceName
    def iamSessionArn: Option[IamSessionArn]
    def iamUserArn: Option[IamUserArn]
    def getInstanceName: ZIO[Any, Nothing, InstanceName] =
      ZIO.succeed(instanceName)
    def getIamSessionArn: ZIO[Any, AwsError, IamSessionArn] =
      AwsError.unwrapOptionField("iamSessionArn", iamSessionArn)
    def getIamUserArn: ZIO[Any, AwsError, IamUserArn] =
      AwsError.unwrapOptionField("iamUserArn", iamUserArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest
  ) extends zio.aws.codedeploy.model.RegisterOnPremisesInstanceRequest.ReadOnly {
    override val instanceName: InstanceName =
      zio.aws.codedeploy.model.primitives.InstanceName(impl.instanceName())
    override val iamSessionArn: Option[IamSessionArn] = scala
      .Option(impl.iamSessionArn())
      .map(value => zio.aws.codedeploy.model.primitives.IamSessionArn(value))
    override val iamUserArn: Option[IamUserArn] = scala
      .Option(impl.iamUserArn())
      .map(value => zio.aws.codedeploy.model.primitives.IamUserArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codedeploy.model.RegisterOnPremisesInstanceRequest
  ): zio.aws.codedeploy.model.RegisterOnPremisesInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
